/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.material.Material;

public class CaveGrassFeature
extends AbstractCaveFeature<Config> {
    public CaveGrassFeature(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public boolean generate(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, Config config) {
        int width = rand.m_188503_(6) + 5;
        int height = rand.m_188503_(6) + 5;
        int depth = rand.m_188503_(6) + 5;
        float grassChance = rand.m_188501_() * 0.25f;
        for (int x = -width; x <= width; ++x) {
            for (int z = -depth; z <= depth; ++z) {
                for (int y = -height; y <= height; ++y) {
                    BlockPos offsetPos;
                    BlockState state;
                    if (!GeometryHelper.isInEllipsoid(width, height, depth, x, y, z) || !SkiesFeatures.Carvers.CARVABLE_BLOCKS.contains((state = world.m_8055_(offsetPos = pos.m_7918_(x, y, z))).m_60734_()) || state.m_60767_() == Material.f_76276_ || state.m_60767_() == Material.f_76316_ || !world.m_46859_(offsetPos.m_7494_())) continue;
                    this.m_5974_((LevelWriter)world, offsetPos, config.grass_block);
                    if (rand.m_188501_() < grassChance) {
                        this.m_5974_((LevelWriter)world, offsetPos.m_7494_(), config.grass);
                    }
                    if (!rand.m_188499_() || offsetPos.m_6625_(1).m_123342_() <= 2) continue;
                    this.m_5974_((LevelWriter)world, offsetPos.m_6625_(1), config.dirt);
                    if (!rand.m_188499_() || offsetPos.m_6625_(2).m_123342_() <= 2) continue;
                    this.m_5974_((LevelWriter)world, offsetPos.m_6625_(2), config.dirt);
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValidPos(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, Config config) {
        return true;
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("grass_block").forGetter(config -> config.grass_block), (App)BlockState.f_61039_.fieldOf("dirt").forGetter(config -> config.dirt), (App)BlockState.f_61039_.fieldOf("grass").forGetter(config -> config.grass)).apply((Applicative)instance, Config::new));
        public final BlockState grass_block;
        public final BlockState dirt;
        public final BlockState grass;

        public Config(BlockState grass_block, BlockState dirt, BlockState grass) {
            this.grass_block = grass_block;
            this.dirt = dirt;
            this.grass = grass;
        }
    }
}

