/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class SkiesSurfaceRules
extends SurfaceRules {
    public static RandomConditionSource randomBoolean(String name) {
        return new RandomConditionSource(BlueSkies.locate(name));
    }

    public record RandomConditionSource(ResourceLocation randomName) implements SurfaceRules.ConditionSource
    {
        public static final KeyDispatchDataCodec<RandomConditionSource> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("random_name").forGetter(RandomConditionSource::randomName)).apply((Applicative)instance, RandomConditionSource::new)));

        public SurfaceRules.Condition apply(SurfaceRules.Context context) {
            PositionalRandomFactory positionalrandomfactory = context.f_224614_.m_224565_(this.randomName());
            RandomSource randomsource = positionalrandomfactory.m_213715_(context.f_189546_, 0, context.f_189547_);
            return new RandomCondition(randomsource);
        }

        public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> m_213794_() {
            return CODEC;
        }

        class RandomCondition
        implements SurfaceRules.Condition {
            private final RandomSource source;

            public RandomCondition(RandomSource randomSource) {
                this.source = randomSource;
            }

            public boolean m_183475_() {
                return this.source.m_188499_();
            }
        }
    }

    public static enum ReservoirMuddiness implements SurfaceRules.RuleSource
    {
        INSTANCE;

        public static final KeyDispatchDataCodec<ReservoirMuddiness> CODEC;

        public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
            return CODEC;
        }

        public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
            return (x, y, z) -> this.getBlocks(x, y, z, context);
        }

        protected BlockState getBlocks(int x, int y, int z, SurfaceRules.Context context) {
            double noise = context.f_189535_.f_189918_.m_75380_((double)x, 0.0, (double)z);
            RandomSource rand = context.f_224614_.m_224565_(BlueSkies.locate("reservoir_mud")).m_213715_(x, 0, z);
            double mudRange = 0.55;
            if (noise < mudRange / 8.25 && noise > -mudRange / 8.25 && rand.m_188501_() < 0.8f) {
                return SkiesBlocks.lunar_mud.m_49966_();
            }
            if (noise < (mudRange + (double)0.7f) / 8.25 && noise > -(mudRange + (double)0.7f) / 8.25 && rand.m_188499_()) {
                return SkiesBlocks.coarse_lunar_dirt.m_49966_();
            }
            return SkiesBlocks.lunar_grass_block.m_49966_();
        }

        static {
            CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
        }
    }

    public static enum CrystalRoughness implements SurfaceRules.RuleSource
    {
        INSTANCE;

        public static final KeyDispatchDataCodec<CrystalRoughness> CODEC;

        public KeyDispatchDataCodec<CrystalRoughness> m_213795_() {
            return CODEC;
        }

        public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
            return (x, y, z) -> this.getBlocks(x, y, z, context);
        }

        protected BlockState getBlocks(int x, int y, int z, SurfaceRules.Context context) {
            RandomSource rand;
            double noise = context.f_189535_.f_189918_.m_75380_((double)x, 0.0, (double)z);
            if (noise > (1.0 + (double)(rand = context.f_224614_.m_224565_(BlueSkies.locate("roughs_crystallization")).m_213715_(x, 0, z)).m_188503_(2)) / 8.25 || noise < 0.0 && noise > -0.18181818181818182 && rand.m_188499_()) {
                return SkiesBlocks.crystal_sand.m_49966_();
            }
            return SkiesBlocks.lunar_grass_block.m_49966_();
        }

        static {
            CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
        }
    }
}

