/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.buckets;

import com.legacy.blue_skies.blocks.util.IFluidLoggable;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;

public class VentiumBucketItem
extends BucketItem {
    public VentiumBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult hitResult;
        ItemStack handStack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)handStack, (HitResult)(hitResult = VentiumBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))));
        if (ret != null) {
            return ret;
        }
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)handStack);
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)handStack);
        }
        BlockPos hitPos = hitResult.m_82425_();
        Direction offset = hitResult.m_82434_();
        BlockPos offsetPos = hitPos.m_121945_(offset);
        if (level.m_7966_(player, hitPos) && player.m_36204_(offsetPos, offset, handStack)) {
            BlockPos placePos;
            BlockState hitState = level.m_8055_(hitPos);
            if (this.getFluid() == Fluids.f_76191_) {
                Block block = hitState.m_60734_();
                if (block instanceof BucketPickup) {
                    ItemStack fullBucket;
                    BucketPickup bucketPickup = (BucketPickup)block;
                    if (VentiumBucketItem.isValidFluid(hitState.m_60819_().m_76152_()) && !(fullBucket = VentiumBucketItem.convertBucket(bucketPickup.m_142598_((LevelAccessor)level, hitPos, hitState))).m_41619_()) {
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        Fluid fluid = hitState.m_60819_().m_76152_();
                        (fluid == Fluids.f_76193_ ? bucketPickup.m_142298_() : fluid.m_142520_()).ifPresent(sound -> player.m_5496_(sound, 1.0f, 1.0f));
                        level.m_142346_((Entity)player, GameEvent.f_157816_, hitPos);
                        ItemStack filledResult = ItemUtils.m_41813_((ItemStack)handStack, (Player)player, (ItemStack)fullBucket);
                        if (!level.f_46443_) {
                            CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, fullBucket);
                        }
                        return InteractionResultHolder.m_19092_((Object)filledResult, (boolean)level.m_5776_());
                    }
                }
                return InteractionResultHolder.m_19100_((Object)handStack);
            }
            BlockPos blockPos = placePos = this.canBlockContainFluid(level, hitPos, hitState) ? hitPos : offsetPos;
            if (this.m_142073_(player, level, placePos, hitResult)) {
                this.m_142131_(player, level, handStack, placePos);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, placePos, handStack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)VentiumBucketItem.getEmptySuccessItem(handStack, player), (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)handStack);
        }
        return InteractionResultHolder.m_19100_((Object)handStack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack stack, Player player) {
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)SkiesItems.ventium_bucket) : stack;
    }

    private boolean canBlockContainFluid(Level level, BlockPos pos, BlockState state) {
        return state.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)state.m_60734_()).m_6044_((BlockGetter)level, pos, state, this.getFluid());
    }

    public static ItemStack convertBucket(ItemStack stack) {
        Item vanillaBucket = stack.m_41720_();
        if (vanillaBucket == Items.f_42447_) {
            return new ItemStack((ItemLike)SkiesItems.ventium_water_bucket);
        }
        if (vanillaBucket == Items.f_42448_) {
            return new ItemStack((ItemLike)SkiesItems.ventium_lava_bucket);
        }
        return stack;
    }

    public static boolean isValidFluid(Fluid fluid) {
        return IFluidLoggable.FluidLogging.isValid(fluid);
    }
}

