/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.events;

import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.blocks.construction.TroughBlock;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.entities.SupporterPetEntity;
import com.legacy.blue_skies.entities.ai.NightwatcherRobGoal;
import com.legacy.blue_skies.entities.ai.ShovelSnowGoal;
import com.legacy.blue_skies.entities.ai.VillagerWanderAtWorkGoal;
import com.legacy.blue_skies.entities.hostile.ArmoredFrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.StoneletEntity;
import com.legacy.blue_skies.entities.hostile.VenomSpiderEntity;
import com.legacy.blue_skies.entities.hostile.boss.AlchemistEntity;
import com.legacy.blue_skies.entities.hostile.boss.ArachnarchEntity;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import com.legacy.blue_skies.entities.util.SkiesEntityHooks;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.entities.villager.SkiesVillagerTrades;
import com.legacy.blue_skies.items.util.FurnaceFuels;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesTriggers;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SkiesEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.f_21345_.m_25352_(1, (Goal)new ShovelSnowGoal(villager, 0.5));
            villager.f_21345_.m_25352_(1, (Goal)new NightwatcherRobGoal(villager, 0.4));
            villager.f_21345_.m_25352_(5, (Goal)new VillagerWanderAtWorkGoal(villager, 0.6));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, SummonerEntity.class, 8.0f, 0.6, 0.6));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, AlchemistEntity.class, 8.0f, 0.6, 0.6));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, ArmoredFrostSpiritEntity.class, 8.0f, 0.6, 0.6));
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingTickEvent event) {
        Animal animal;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            SkiesPlayer.ifPresent(p, skyPlayer -> skyPlayer.serverTick());
        }
        if (entity.m_21124_(SkiesEffects.DEADLY_VENOM) != null) {
            boolean canDeadlyVenomHurt;
            MobEffectInstance effect = entity.m_21124_(SkiesEffects.DEADLY_VENOM);
            int difficultyTimePerHit = effect.m_19564_() == 0 ? 12 : (effect.m_19564_() == 1 ? 11 : 2);
            boolean bl = canDeadlyVenomHurt = entity.f_19797_ % difficultyTimePerHit == 0;
            if (canDeadlyVenomHurt) {
                entity.m_6469_(EntityUtil.DamageSources.DEADLY_VENOM, 2.0f);
            }
        }
        if (entity.f_19853_ instanceof ServerLevel && entity instanceof Animal && (animal = (Animal)entity).m_6162_() && animal.f_19853_.f_46441_.m_188501_() < 0.3f && animal.f_19797_ % (200 + animal.m_217043_().m_188503_(50)) == 0) {
            BlockState trough;
            int radius = 7;
            Stream<PoiRecord> poi = EntityUtil.getPoisInCircle((Entity)animal, (ResourceKey<PoiType>)SkiesPoiTypes.TROUGH.getKey(), radius);
            Optional<PoiRecord> optional = poi.findAny();
            if (optional.isPresent() && TroughBlock.canConsume(trough = entity.f_19853_.m_8055_(optional.get().m_27257_()), (LevelAccessor)entity.f_19853_)) {
                animal.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                if (animal.f_19853_.f_46441_.m_188501_() < 0.3f) {
                    TroughBlock.attemptConsume(trough, (LevelAccessor)entity.f_19853_, optional.get().m_27257_());
                    animal.m_146740_(30 + animal.f_19853_.f_46441_.m_188503_(10), true);
                } else {
                    animal.m_146740_(10 + animal.f_19853_.f_46441_.m_188503_(10), true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().f_19853_.f_46443_ && (livingEntity = event.getEntity()) instanceof ISkyBoss) {
            ISkyBoss boss = (ISkyBoss)livingEntity;
            AABB radiusCheck = new AABB(event.getEntity().m_20183_()).m_82377_(25.0, 15.0, 25.0);
            List playerList = event.getEntity().f_19853_.m_45976_(Player.class, radiusCheck);
            for (Player player : playerList) {
                SkiesPlayer.ifPresent(player, skiesPlayer -> {
                    if (boss.isDungeonSpawned()) {
                        if (boss.isEverbrightBoss() && skiesPlayer.getBrightProgression() == boss.getProgression() - 1) {
                            EntityUtil.sendJournalToast(player);
                            skiesPlayer.setBrightProgression((byte)boss.getProgression());
                        } else if (!boss.isEverbrightBoss() && skiesPlayer.getDawnProgression() == boss.getProgression() - 1) {
                            EntityUtil.sendJournalToast(player);
                            skiesPlayer.setDawnProgression((byte)boss.getProgression());
                        }
                    }
                    skiesPlayer.syncDataToClient();
                });
            }
        }
    }

    @SubscribeEvent
    public static void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        Mob entity = event.getEntity();
        if (SkiesDimensions.inSkyDimension((Entity)entity)) {
            if (event.getSpawnReason() == MobSpawnType.NATURAL) {
                if (!BlueSkiesConfig.COMMON.isEntityAllowedToSpawn(entity.m_6095_())) {
                    event.setResult(Event.Result.DENY);
                }
                if (entity instanceof CaveSpider && (event.getLevel().m_46861_(entity.m_20183_()) || entity.m_20183_().m_123342_() > 50 || EntityUtil.isPosInStructure(entity.f_19853_, entity.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.POISON_DUNGEON.getStructure()) && (entity.f_19853_.f_46441_.m_188503_(7) != 0 || entity.m_20183_().m_123342_() < 15 || entity.m_20183_().m_123342_() > 50))) {
                    event.setResult(Event.Result.DENY);
                }
                if (entity instanceof VenomSpiderEntity && entity.m_20183_().m_123342_() < 15 && EntityUtil.isPosInStructure(entity.f_19853_, entity.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.POISON_DUNGEON.getStructure())) {
                    event.setResult(Event.Result.DENY);
                }
            }
            if (entity instanceof StoneletEntity && EntityUtil.isPosInStructure(entity.f_19853_, entity.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.NATURE_DUNGEON.getStructure()) && (event.getSpawnReason() == MobSpawnType.NATURAL || event.getSpawnReason() == MobSpawnType.SPAWNER)) {
                boolean flag = EntityUtil.canSpawnWithoutFlooding((LivingEntity)entity);
                if (!(entity.m_20183_().m_123342_() <= 145 || entity.f_19853_.m_45527_(entity.m_20183_()) && entity.f_19853_.m_8055_(entity.m_20183_().m_7495_()).m_60734_() == SkiesBlocks.turquoise_cherry_grass_block)) {
                    event.setResult(Event.Result.DENY);
                }
                if (flag) {
                    event.setResult(Event.Result.ALLOW);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
        if (entity.m_6095_().m_20674_() == MobCategory.MONSTER && (event.getSpawnReason() == MobSpawnType.NATURAL || event.getSpawnReason() == MobSpawnType.SPAWNER) && entity.f_19853_ instanceof ServerLevel && EntityUtil.getPoisInCircle((Entity)entity, (ResourceKey<PoiType>)SkiesPoiTypes.WARDING_PEARL.getKey(), 25).findAny().isPresent()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onVillagerTradesAssigned(VillagerTradesEvent event) {
        try {
            if (event.getType() == VillagerProfession.f_35588_) {
                ((List)event.getTrades().get(2)).add(SkiesVillagerTrades.BLINDING_DUNGEON_OFFER);
                ((List)event.getTrades().get(3)).add(SkiesVillagerTrades.POPULATION_DUNGEON_OFFER);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        LivingEntity livingEntity;
        if (event.getTarget() instanceof SupporterPetEntity && (livingEntity = event.getEntity()) instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.m_6710_(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void nerfReachAttacks(LivingDamageEvent event) {
        float maxDist;
        double dist;
        DamageSource source;
        ISkyBoss boss;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ISkyBoss && (boss = (ISkyBoss)livingEntity).getMaxReach() >= 0.0f && !event.getSource().m_19390_() && (source = event.getSource()).m_7640_() instanceof Player && (dist = (double)source.m_7640_().m_20270_((Entity)event.getEntity())) > (double)(maxDist = boss.getMaxReach())) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        if (source.m_7640_() != null) {
            if (event.getEntity() == source.m_7639_()) {
                return;
            }
            if (SkiesDimensions.inSkyDimension(source.m_7640_())) {
                if (source.m_7640_() instanceof Player) {
                    event.setAmount(SkiesEntityHooks.nerfDamage(source, event.getAmount()));
                } else if (source.m_19360_() || source instanceof IndirectEntityDamageSource) {
                    event.setAmount(source.m_7639_() == null ? Math.min(5.0f, event.getAmount()) : SkiesEntityHooks.nerfIndirectDamage(source, event.getAmount()));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void capBossDamage(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ISkyBoss) {
            ISkyBoss boss = (ISkyBoss)livingEntity;
            if (event.getAmount() > (float)boss.getDamageCap() && !source.m_19390_() && event.getSource() != DamageSource.f_19317_) {
                event.setAmount((float)boss.getDamageCap());
            }
        }
        if (source.m_7640_() != null && source.m_7639_() != null && (livingEntity = source.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getAmount() >= event.getEntity().m_21223_()) {
                if (event.getEntity() instanceof StarlitCrusherEntity && source.m_7640_() == player && !player.m_6117_() && player.m_21205_().m_41619_()) {
                    SkiesTriggers.SPECIAL_CRUSHER_KILL.trigger(player);
                } else {
                    ArachnarchEntity arach;
                    LivingEntity livingEntity2 = event.getEntity();
                    if (livingEntity2 instanceof ArachnarchEntity && (arach = (ArachnarchEntity)livingEntity2).isCeilingLocked()) {
                        SkiesTriggers.SPECIAL_ARACHNARCH_KILL.trigger(player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        if (event.getEntity() instanceof ISkyBoss && !(event.getEntity() instanceof SkiesIllagerBossEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosionStart(ExplosionEvent.Start event) {
        if (EntityUtil.isInDungeon(event.getLevel(), new BlockPos(event.getExplosion().getPosition()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        ArrayList blocks = new ArrayList(event.getAffectedBlocks());
        blocks.forEach(positions -> {
            if (EntityUtil.isInDungeon(event.getLevel(), positions)) {
                event.getAffectedBlocks().remove(positions);
            }
        });
    }

    @SubscribeEvent
    public static void onMobGrief(EntityMobGriefingEvent event) {
        if (event.getEntity() != null && SkiesDimensions.inSkyDimension(event.getEntity()) && EntityUtil.isInDungeon(event.getEntity().f_19853_, event.getEntity().m_20183_())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity;
        if (event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof AlchemistEntity) {
            AlchemistEntity alch = (AlchemistEntity)entity;
            Projectile projectile = event.getProjectile();
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrowOld = (AbstractArrow)projectile;
                if (!(event.getProjectile() instanceof ThrownTrident) && !(event.getProjectile() instanceof SpearEntity)) {
                    LivingEntity living;
                    Entity entity2;
                    LivingEntity target;
                    event.setCanceled(true);
                    LivingEntity livingEntity = target = arrowOld.m_37282_() != null && (entity2 = arrowOld.m_37282_()) instanceof LivingEntity ? (living = (LivingEntity)entity2) : alch.m_5448_();
                    if (!alch.f_19853_.f_46443_ && target != null) {
                        Arrow arrow = new Arrow(alch.f_19853_, (LivingEntity)alch);
                        arrow.m_36870_(new MobEffectInstance(MobEffects.f_19614_, 300, 2));
                        arrow.m_36870_(new MobEffectInstance(MobEffects.f_19610_, 200));
                        arrow.m_36735_(1);
                        arrow.m_36762_(true);
                        double d0 = target.m_20185_() - alch.m_20185_();
                        double d1 = target.m_20227_(0.3333333333333333) - alch.m_20186_();
                        double d2 = target.m_20189_() - alch.m_20189_();
                        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                        arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.5f, (float)Math.max(0, 16 - alch.getDifficultyID() * 4));
                        arrow.m_36781_(12.0);
                        alch.m_5496_(SoundEvents.f_12052_, 1.0f, 1.0f);
                        alch.m_21373_();
                        alch.f_19853_.m_7967_((Entity)arrow);
                        arrowOld.m_146870_();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void getBurnTime(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().equals("blue_skies")) {
            event.setBurnTime(FurnaceFuels.getBurnTime(item));
        }
    }
}

