/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.legacy.blue_skies.items.tools.weapons.SpearItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class SpearEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.m_135353_(SpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> HAS_EFFECT = SynchedEntityData.m_135353_(SpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final float BASE_DAMAGE = 8.0f;
    private ItemStack thrownStack = new ItemStack((ItemLike)SkiesItems.bluebright_spear);
    private boolean dealtDamage;
    public int returningTicks;
    protected IntOpenHashSet spearPiercedEntities = null;

    public SpearEntity(EntityType<? extends SpearEntity> type, Level worldIn) {
        super(type, worldIn);
        this.setState();
    }

    public SpearEntity(Level worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super(SkiesEntityTypes.SPEAR, thrower, worldIn);
        this.thrownStack = thrownStackIn.m_41777_();
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)this.getLoyalty(thrownStackIn));
        this.f_19804_.m_135381_(HAS_EFFECT, (Object)thrownStackIn.m_41790_());
        this.setState();
    }

    @OnlyIn(value=Dist.CLIENT)
    public SpearEntity(Level worldIn, double x, double y, double z) {
        super(SkiesEntityTypes.SPEAR, x, y, z, worldIn);
    }

    public SpearEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(SkiesEntityTypes.SPEAR, world);
        this.setState();
    }

    public void setState() {
        this.f_19853_.m_7605_((Entity)this, Type.getValue(this.thrownStack.m_41720_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        this.thrownStack = new ItemStack((ItemLike)Type.getSpear(id));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(HAS_EFFECT, (Object)false);
    }

    public void m_8119_() {
        if (this.f_19797_ == 1) {
            this.setState();
        }
        if (this.f_36701_ != this.spearPiercedEntities) {
            this.f_36701_ = this.spearPiercedEntities;
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_37282_();
        if ((this.dealtDamage || this.m_36797_()) && entity != null) {
            byte i = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
            if (i > 0 && !this.shouldReturnToThrower()) {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else if (i > 0) {
                this.m_36790_(true);
                Vec3 vec3d = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20188_() - this.m_20186_(), entity.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3d.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3d.m_82541_().m_82490_(d0)));
                if (this.returningTicks == 0) {
                    this.m_5496_(SkiesSounds.ITEM_SPEAR_RETURN, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.m_8119_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.m_37282_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    public ItemStack m_7941_() {
        return this.thrownStack.m_41777_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasEffect() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EFFECT);
    }

    protected EntityHitResult m_6351_(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.m_6351_(startVec, endVec);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        float damage = ToolUtils.getProjectileDamage(8.0f, this.thrownStack.m_41720_() instanceof SpearItem ? ((SpearItem)this.thrownStack.m_41720_()).getStick() : Items.f_42398_);
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.thrownStack, (MobType)livingentity.m_6336_());
        }
        if (this.m_36796_() > 0 && !entity.m_5829_()) {
            if (this.spearPiercedEntities == null) {
                this.spearPiercedEntities = new IntOpenHashSet(5);
            }
            if (this.spearPiercedEntities.size() >= this.m_36796_() + 1) {
                this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
                this.dealtDamage = true;
                return;
            }
            this.spearPiercedEntities.add(entity.m_19879_());
        } else {
            this.dealtDamage = true;
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        }
        Entity entity1 = this.m_37282_();
        DamageSource damagesource = DamageSource.m_19337_((Entity)this, (Entity)(entity1 == null ? this : entity1));
        SoundEvent soundevent = SkiesSounds.ITEM_SPEAR_HIT;
        if (entity.m_6469_(damagesource, damage) && entity instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity;
            if (entity1 instanceof LivingEntity) {
                EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
            }
            this.m_7761_(livingentity1);
        }
        float f1 = 1.0f;
        this.m_5496_(soundevent, f1, 1.0f);
        if (this.f_36701_ != this.spearPiercedEntities) {
            this.f_36701_ = this.spearPiercedEntities;
        }
    }

    protected SoundEvent m_7239_() {
        return SkiesSounds.ITEM_SPEAR_HIT_GROUND;
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        HitResult.Type raytraceresult$type = raytraceResultIn.m_6662_();
        if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.m_5496_(SkiesSounds.ITEM_SPEAR_HIT_GROUND, 1.0f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
        }
        super.m_6532_(raytraceResultIn);
    }

    public void m_6123_(Player entityIn) {
        Entity entity = this.m_37282_();
        if (entity == null || entity.m_20148_() == entityIn.m_20148_()) {
            super.m_6123_(entityIn);
        }
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        if (compound.m_128425_("Spear", 10)) {
            this.thrownStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Spear"));
        }
        this.dealtDamage = compound.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)this.getLoyalty(this.thrownStack));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Spear", (Tag)this.thrownStack.m_41739_(new CompoundTag()));
        compound.m_128379_("DealtDamage", this.dealtDamage);
    }

    protected void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public byte getLoyalty(ItemStack stack) {
        int loyaltyLevel = EnchantmentHelper.m_44928_((ItemStack)stack);
        return (byte)(stack.m_41720_() == SkiesItems.soulbound_spear ? Math.max(1, loyaltyLevel) : loyaltyLevel);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        BLUEBRIGHT(0, SkiesItems.bluebright_spear),
        STARLIT(1, SkiesItems.starlit_spear),
        FROSTBRIGHT(2, SkiesItems.frostbright_spear),
        LUNAR(3, SkiesItems.lunar_spear),
        DUSK(4, SkiesItems.dusk_spear),
        MAPLE(5, SkiesItems.maple_spear),
        CHERRY(6, SkiesItems.cherry_spear),
        SOULBOUND(7, SkiesItems.soulbound_spear);

        final byte value;
        final Item item;

        private Type(int value, Item item) {
            this.value = (byte)value;
            this.item = item;
        }

        public static Item getSpear(byte value) {
            for (Type type : Type.values()) {
                if (type.value != value) continue;
                return type.item;
            }
            return Type.BLUEBRIGHT.item;
        }

        public static byte getValue(Item item) {
            for (Type type : Type.values()) {
                if (type.item != item) continue;
                return type.value;
            }
            return Type.BLUEBRIGHT.value;
        }
    }
}

