/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.entities.ai.FollowDirectlyTemptGoal;
import com.legacy.blue_skies.entities.util.base.SkiesAnimalEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class AzulfoEntity
extends SkiesAnimalEntity {
    private AzulfoEntity herdLeader;
    private int herdSize = 1;
    public int attackTimer = 11;

    public AzulfoEntity(EntityType<? extends AzulfoEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 1.0f;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.7f, false){

            public boolean m_8036_() {
                return !AzulfoEntity.this.m_6162_() && super.m_8036_();
            }

            protected double m_6639_(LivingEntity attackTarget) {
                return super.m_6639_(attackTarget) * (double)0.6f;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new FollowDirectlyTemptGoal((PathfinderMob)this, 1.4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{SkiesItems.pine_fruit})));
        this.f_21345_.m_25352_(4, (Goal)new FollowHerdLeaderGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.3));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.25, 0.01f){

            public boolean m_8036_() {
                return (!AzulfoEntity.this.hasHerdLeader() || AzulfoEntity.this.isHerdLeader()) && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22284_, 4.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (!this.m_6162_()) {
            if (spawnDataIn == null) {
                spawnDataIn = new HerdData(this);
            } else {
                this.joinHerd(((HerdData)spawnDataIn).herdLeader);
            }
        }
        return spawnDataIn;
    }

    public void m_8107_() {
        List list;
        super.m_8107_();
        if (this.attackTimer < 11) {
            ++this.attackTimer;
        }
        if (this.isHerdLeader() && this.f_19853_.f_46441_.m_188503_(200) == 1 && (list = this.f_19853_.m_45976_(AzulfoEntity.class, this.m_20191_().m_82377_(20.0, 20.0, 20.0))).size() <= 1) {
            this.herdSize = 1;
        }
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_AZULFO_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_AZULFO_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_AZULFO_DEATH;
    }

    @Override
    public Item getMainBreedingItem() {
        return SkiesItems.pine_fruit;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public AzulfoEntity createChild(AgeableMob ageable) {
        return (AzulfoEntity)SkiesEntityTypes.AZULFO.m_20615_(this.f_19853_);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? 0.8f : 1.8f;
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.attackTimer >= 11) {
            this.attackTimer = 0;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
        return entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), 3.0f);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public AzulfoEntity joinHerd(AzulfoEntity herdLeaderIn) {
        this.herdLeader = herdLeaderIn;
        herdLeaderIn.increaseHerdSize();
        return herdLeaderIn;
    }

    public void leaveHerd() {
        this.herdLeader.decreaseHerdSize();
        this.herdLeader = null;
    }

    private void increaseHerdSize() {
        ++this.herdSize;
    }

    private void decreaseHerdSize() {
        --this.herdSize;
    }

    public boolean canHerdGrow() {
        return this.isHerdLeader() && this.herdSize < this.getMaxHerdSize();
    }

    public int getMaxSpawnedInChunk() {
        return this.getMaxHerdSize();
    }

    public int getMaxHerdSize() {
        return super.m_5792_();
    }

    public boolean isHerdLeader() {
        return this.herdSize > 1;
    }

    public boolean inRangeOfHerdLeader() {
        return (double)this.m_20270_((Entity)this.herdLeader) <= 20.0;
    }

    public void moveToHerdLeader() {
        if (this.isPosTooFarFromLeader(this.m_20183_())) {
            this.m_21573_().m_5624_((Entity)this.herdLeader, 1.45);
        }
    }

    public boolean hasHerdLeader() {
        return this.herdLeader != null && this.herdLeader.m_6084_();
    }

    public boolean isPosTooFarFromLeader(BlockPos pos) {
        return this.hasHerdLeader() && (double)EntityUtil.getDistanceToPos((Vec3i)pos, (Vec3i)this.herdLeader.m_20183_()) > 12.0;
    }

    public void getHerdMembers(Stream<AzulfoEntity> membersIn) {
        membersIn.limit(this.getMaxHerdSize() - this.herdSize).filter(p_212801_1_ -> p_212801_1_ != this).forEach(member -> {
            if (!member.m_6162_()) {
                member.joinHerd(this);
            }
        });
    }

    public class FollowHerdLeaderGoal
    extends Goal {
        private final AzulfoEntity taskOwner;
        private int navigateTimer;
        private int cooldown;

        public FollowHerdLeaderGoal(AzulfoEntity taskOwnerIn) {
            this.taskOwner = taskOwnerIn;
            this.cooldown = this.getNewCooldown(taskOwnerIn);
        }

        protected int getNewCooldown(AzulfoEntity taskOwnerIn) {
            return 200 + taskOwnerIn.m_217043_().m_188503_(200) % 20;
        }

        public boolean m_8036_() {
            if (this.taskOwner.isHerdLeader() || this.taskOwner.m_6162_()) {
                return false;
            }
            if (this.taskOwner.hasHerdLeader()) {
                return true;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.cooldown = this.getNewCooldown(this.taskOwner);
            Predicate<AzulfoEntity> canJoinHerd = azulfo -> azulfo.canHerdGrow() || !azulfo.hasHerdLeader();
            List list = this.taskOwner.f_19853_.m_6443_(AzulfoEntity.class, this.taskOwner.m_20191_().m_82377_(20.0, 20.0, 20.0), canJoinHerd);
            AzulfoEntity azulfos = list.stream().filter(AzulfoEntity::canHerdGrow).findAny().orElse(this.taskOwner);
            azulfos.getHerdMembers(list.stream().filter(azulfo -> !azulfo.hasHerdLeader()));
            return this.taskOwner.hasHerdLeader();
        }

        public boolean m_8045_() {
            return this.taskOwner.hasHerdLeader() && this.taskOwner.inRangeOfHerdLeader();
        }

        public void m_8056_() {
            this.navigateTimer = 0;
        }

        public void m_8041_() {
            this.taskOwner.leaveHerd();
        }

        public void m_8037_() {
            if (--this.navigateTimer <= 0) {
                this.navigateTimer = 10;
                this.taskOwner.moveToHerdLeader();
            }
        }
    }

    public static class HerdData
    extends AgeableMob.AgeableMobGroupData
    implements SpawnGroupData {
        public final AzulfoEntity herdLeader;

        public HerdData(AzulfoEntity herdLeaderIn) {
            super(true);
            this.herdLeader = herdLeaderIn;
        }
    }
}

