/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.capability;

import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArcInventory
implements Container {
    public static final int SIZE = 4;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final List<Consumer<ArcInventory>> listeners = new ArrayList<Consumer<ArcInventory>>();

    public void addListener(Consumer<ArcInventory> listener) {
        this.listeners.add(listener);
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public int m_6643_() {
        return 4;
    }

    public boolean m_7983_() {
        for (int i = 0; i < 4; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return index >= 0 && index < 4 ? (ItemStack)this.items.get(index) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
    }

    public void m_6596_() {
        for (int i = this.listeners.size() - 1; i > -1; --i) {
            this.listeners.get(i).accept(this);
        }
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return stack.m_41720_() instanceof IArcItem;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.items;
    }

    public void refreshArcs(Player player) {
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            Item item = stack.m_41720_();
            if (!(item instanceof IArcItem)) continue;
            IArcItem arc = (IArcItem)item;
            arc.refresh(stack, player);
        }
    }

    public boolean hasArc(BiFunction<ItemStack, IArcItem, Boolean> condition) {
        for (int i = 0; i < 4; ++i) {
            IArcItem arc;
            ItemStack stack = (ItemStack)this.items.get(i);
            Item item = stack.m_41720_();
            if (!(item instanceof IArcItem) || !condition.apply(stack, arc = (IArcItem)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasArc(IArcItem arc) {
        for (int i = 0; i < 4; ++i) {
            if (((ItemStack)this.items.get(i)).m_41720_() != arc) continue;
            return true;
        }
        return false;
    }

    public boolean hasEmpoweredDusk(Player player) {
        return this.hasArc((ItemStack stack, IArcItem arc) -> SkiesItems.dusk_arc == arc && arc.getFunctionalLevel((ItemStack)stack, player) >= 3);
    }

    public ListTag write(ListTag tagList) {
        for (int i = 0; i < 4; ++i) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_("Slot", (byte)i);
            ((ItemStack)this.items.get(i)).m_41739_(nbt);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    public void read(ListTag tagList) {
        this.items.clear();
        for (int i = 0; i < 4; ++i) {
            CompoundTag nbt = tagList.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt);
            this.items.set(i, (Object)stack);
        }
        this.m_6596_();
    }
}

