/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkyWebbingBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty HAS_COLLISION = BooleanProperty.m_61465_((String)"has_collision");
    public static final VoxelShape X = Block.m_49796_((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)16.0, (double)16.0);
    public static final VoxelShape Y = Block.m_49796_((double)0.0, (double)7.5, (double)0.0, (double)16.0, (double)8.5, (double)16.0);
    public static final VoxelShape Z = Block.m_49796_((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.5);

    public SkyWebbingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_COLLISION, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean xFlag = false;
        boolean yFlag = false;
        boolean zFlag = false;
        if (this.connectedAtCorner(state, NORTH, UP, SOUTH, DOWN)) {
            xFlag = true;
        }
        if (this.connectedAtCorner(state, NORTH, EAST, SOUTH, WEST)) {
            yFlag = true;
        }
        if (this.connectedAtCorner(state, EAST, UP, WEST, DOWN)) {
            zFlag = true;
        }
        if (xFlag && yFlag && zFlag) {
            return Shapes.m_83144_();
        }
        VoxelShape shape = Shapes.m_83040_();
        if (xFlag) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)X);
        }
        if (yFlag) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Y);
        }
        if (zFlag) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Z);
        }
        return shape;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)HAS_COLLISION)).booleanValue()) {
            return this.m_5940_(state, worldIn, pos, context);
        }
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        VoxelShape shape;
        if (!((Boolean)state.m_61143_((Property)HAS_COLLISION)).booleanValue() && !(shape = state.m_60808_((BlockGetter)worldIn, pos)).m_83281_() && shape.m_83215_().m_82338_(pos).m_82381_(entityIn.m_20191_())) {
            entityIn.m_7601_(state, new Vec3(0.75, 0.55, 0.75));
        }
    }

    public boolean connectedAtCorner(BlockState state, BooleanProperty a, BooleanProperty b, BooleanProperty c, BooleanProperty d) {
        return (Boolean)state.m_61143_((Property)a) != false && (Boolean)state.m_61143_((Property)b) != false || (Boolean)state.m_61143_((Property)b) != false && (Boolean)state.m_61143_((Property)c) != false || (Boolean)state.m_61143_((Property)c) != false && (Boolean)state.m_61143_((Property)d) != false || (Boolean)state.m_61143_((Property)d) != false && (Boolean)state.m_61143_((Property)a) != false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : (BlockState)stateIn.m_61124_((Property)this.getProperty(facing), (Comparable)Boolean.valueOf(this.canAttachTo(facingState, facingState.m_60783_((BlockGetter)worldIn, facingPos, facing.m_122424_()))));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Level world = context.m_43725_();
        for (Direction facing : Direction.values()) {
            BlockPos facingPos = context.m_8083_().m_121945_(facing);
            BlockState facingState = world.m_8055_(facingPos);
            state = (BlockState)state.m_61124_((Property)this.getProperty(facing), (Comparable)Boolean.valueOf(this.canAttachTo(facingState, facingState.m_60783_((BlockGetter)world, facingPos, facing.m_122424_()))));
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            BlockPos facingPos = pos.m_121945_(facing);
            BlockState facingState = worldIn.m_8055_(facingPos);
            state = (BlockState)state.m_61124_((Property)this.getProperty(facing), (Comparable)Boolean.valueOf(this.canAttachTo(facingState, facingState.m_60783_((BlockGetter)worldIn, facingPos, facing.m_122424_()))));
        }
        return this.connectedAtCorner(state, NORTH, EAST, SOUTH, WEST) || this.connectedAtCorner(state, NORTH, UP, SOUTH, DOWN) || this.connectedAtCorner(state, EAST, UP, WEST, DOWN);
    }

    public final boolean canAttachTo(BlockState attachState, boolean ifSolidSide) {
        Block block = attachState.m_60734_();
        return !SkyWebbingBlock.m_152463_((BlockState)attachState) && ifSolidSide || block instanceof SkyWebbingBlock || block instanceof WebBlock;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, HAS_COLLISION});
    }

    public BooleanProperty getProperty(Direction facing) {
        switch (facing) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
        }
        return DOWN;
    }
}

