/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;

public class Wind
implements IWind,
IHaveConfig {
    public static final FloatBounds STRENGTH_BOUNDS = FloatBounds.between(Float.valueOf(0.0f), Float.valueOf(0.3f));
    protected static final FloatBounds STEP_BOUNDS = FloatBounds.between(Float.valueOf(0.0f), Float.valueOf(0.01f));
    protected static final int SCALE = 100;
    public static final Wind NONE;
    public static Wind defaultWind;
    public static int randomSeed;
    protected final BiomeId biome;
    protected final FloatBounds strengthBounds;
    protected final float changeProbability;
    protected final float changeStep;
    protected final GameTime changeInterval = GameTime.second();
    protected final GameTime updateInterval = GameTime.quaterSecond();
    protected Vect3d currentMotion = Vect3d.ZERO;
    protected Vect3d targetMotion = Vect3d.ZERO;
    private final UnitConfig config;

    public Wind(@Nullable UnitConfig config, BiomeId biome, float strengthMax, float changeProbability, float changeStep) {
        this.config = config;
        this.biome = biome;
        strengthMax = (float)UnitConfig.getInt(config, this.getClassCategory(), "maxStrength", Math.round(strengthMax * 100.0f), IntBounds.of(STRENGTH_BOUNDS.scale(100.0f)), "Defines maximum wind strength.") / 100.0f;
        this.strengthBounds = FloatBounds.between(Float.valueOf(-strengthMax), Float.valueOf(strengthMax));
        this.changeProbability = UnitConfig.getFloat(config, this.getClassCategory(), "changeProbability", changeProbability * 100.0f, GameBounds.PERCENTAGE.getFloatBounds(), "Defines probability of wind strength and direction change in percentage.") / 100.0f;
        this.changeStep = UnitConfig.getFloat(config, this.getClassCategory(), "changeStep", changeStep * 100.0f, STEP_BOUNDS.scale(100.0f), "Defines how fast the wind changes.") / 100.0f;
        this.randomChangeTargetMotion();
        this.currentMotion = this.targetMotion;
        this.saveConfig();
    }

    public static Wind from(UnitConfig config, BiomeId biome) {
        return new Wind(config, biome, Wind.defaultWind.strengthBounds.getMax().floatValue(), Wind.defaultWind.changeProbability, Wind.defaultWind.changeStep);
    }

    @Override
    public Vect3d getMotion() {
        return this.currentMotion;
    }

    void setCurrentMotion(Vect3d motion) {
        this.currentMotion = motion;
    }

    public Vect3d getTargetMotion() {
        return this.targetMotion;
    }

    protected void randomChangeTargetMotion() {
        this.targetMotion = Vect3d.from(this.strengthBounds.randomBetween().floatValue(), 0.0, this.strengthBounds.randomBetween().floatValue());
    }

    protected double getChangedMotion(double motion, double targetMotion) {
        double delta = targetMotion - motion;
        if (Math.abs(delta) <= (double)Math.abs(this.changeStep)) {
            return targetMotion;
        }
        double changedMotion = motion;
        if (motion < targetMotion) {
            changedMotion += (double)this.changeStep;
        }
        if (motion > targetMotion) {
            changedMotion -= (double)this.changeStep;
        }
        changedMotion = this.strengthBounds.enclose(Float.valueOf((float)changedMotion)).floatValue();
        return changedMotion;
    }

    public void update(Level world) {
        if (this == NONE) {
            return;
        }
        if (GameWorld.isServerSide((LevelReader)world) && this.changeInterval.pastIn(world) && CommonMath.Random.result(this.changeProbability)) {
            this.randomChangeTargetMotion();
            WindMsg message = new WindMsg(this);
            ForgeEndertech.getInstance().getConnection().sendToAll(message);
        }
        if (this.updateInterval.pastIn(world)) {
            double x = this.getChangedMotion(this.getMotion().x, this.getTargetMotion().x);
            double y = 0.0;
            double z = this.getChangedMotion(this.getMotion().z, this.getTargetMotion().z);
            this.currentMotion = Vect3d.from(x, y, z);
        }
    }

    @Override
    @Nullable
    public UnitConfig getConfig() {
        return this.config;
    }

    public boolean equalsDefault() {
        return this.strengthBounds.equals(Wind.defaultWind.strengthBounds) && this.changeProbability == Wind.defaultWind.changeProbability && this.changeStep == Wind.defaultWind.changeStep;
    }

    static {
        defaultWind = NONE = new Wind(null, null, 0.0f, 0.0f, 0.0f);
        randomSeed = 0;
    }

    public static class WindMsg
    extends ForgeNetMsg<WindMsg> {
        public String biomeName;
        public Vect3d targetMotion;
        public boolean isDefaultWind;
        public float strengthMax;
        public float changeProbability;
        public float changeStep;

        public WindMsg() {
        }

        public WindMsg(Wind wind) {
            this.biomeName = wind.biome.getResourceLocation().map(loc -> loc.toString()).orElse("");
            this.targetMotion = wind.targetMotion;
            this.isDefaultWind = wind == defaultWind;
            this.strengthMax = wind.strengthBounds.getMax().floatValue();
            this.changeProbability = wind.changeProbability;
            this.changeStep = wind.changeStep;
        }

        @Override
        public WindMsg create() {
            return new WindMsg();
        }

        @Override
        public void handle(Level level, Player player) {
            BiomeId biome = BiomeId.from(new ResourceLocation(this.biomeName));
            Wind wind = new Wind(null, biome, this.strengthMax, this.changeProbability, this.changeStep);
            wind.targetMotion = this.targetMotion;
            wind.setCurrentMotion(this.targetMotion);
            if (this.isDefaultWind) {
                Vect3d motion = defaultWind.getMotion();
                wind.setCurrentMotion(motion);
                defaultWind = wind;
            } else {
                GameWorld.WorldData data = GameWorld.getData((LevelAccessor)level);
                Wind oldWind = data.biomeWindMap.get(biome);
                if (oldWind != null) {
                    wind.setCurrentMotion(oldWind.getMotion());
                }
                data.biomeWindMap.put(wind.biome, wind);
            }
        }
    }

    public static class StaticWind
    implements IWind {
        private final Vect3d motion;

        public StaticWind(Vect3d motion) {
            this.motion = motion;
        }

        public static StaticWind from(float strength, CommonMath.Angle angle) {
            double x = -angle.sin() * (double)strength;
            double z = angle.cos() * (double)strength;
            Vect3d motion = Vect3d.from(x, 0.0, z);
            return new StaticWind(motion);
        }

        @Override
        public Vect3d getMotion() {
            return this.motion;
        }
    }
}

