/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.FloatBounds;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Map<Block, LootTable.Builder> blockLootTables = new HashMap<Block, LootTable.Builder>();
    protected final Map<ResourceLocation, LootTable> customLootTables = new HashMap<ResourceLocation, LootTable>();
    protected final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    protected abstract void addTables();

    public abstract String m_6055_();

    protected LootPool.Builder blockPool(String name, Block block) {
        return LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block));
    }

    protected void addBlock(String name, Block block, BlockEntityType<?> type) {
        this.addBlockPool(block, this.blockPool(name, block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Info", "BlockEntityTag.Info", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("Inventory", "BlockEntityTag.Inventory", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE)).m_79078_((LootItemFunction.Builder)SetContainerContents.m_193036_(type).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
    }

    protected void addBlock(RegistryObject<? extends Block> block) {
        this.addBlock(block.getId().m_135815_(), (Block)block.get());
    }

    protected void addBlock(String name, Block block) {
        this.addBlockPool(block, this.blockPool(name, block));
    }

    protected void addBlockPool(Block block, LootPool.Builder pool) {
        this.blockLootTables.put(block, LootTable.m_79147_().m_79161_(pool));
    }

    protected void addBlockSilkTouch(String name, Block block, Item lootItem, FloatBounds count) {
        this.addBlockPool(block, LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), LootItem.m_79579_((ItemLike)lootItem).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)count.getMin().floatValue(), (float)count.getMax().floatValue()))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())})));
    }

    public void m_213708_(CachedOutput cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        this.blockLootTables.forEach((block, builder) -> tables.put(block.m_60589_(), builder.m_79165_(LootContextParamSets.f_81421_).m_79167_()));
        this.customLootTables.forEach(tables::put);
        this.writeTables(cache, tables);
    }

    protected void writeTables(CachedOutput cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.m_123916_();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.m_135827_() + "/loot_tables/" + key.m_135815_() + ".json");
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }
}

