/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.IBounds;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;

public class IntBounds
implements IBounds<Integer>,
Iterable<Integer> {
    public static final IntBounds ZERO = new IntBounds(0, 0);
    public static final IntBounds INTEGER = new IntBounds(Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final IntBounds INTEGER_POSITIVE = new IntBounds(0, Integer.MAX_VALUE);
    private final Integer min;
    private final Integer max;

    public IntBounds(Integer bound1, Integer bound2) {
        this.min = Math.min(bound1, bound2);
        this.max = Math.max(bound1, bound2);
    }

    public IntBounds(Integer bound) {
        this(bound, bound);
    }

    public static IntBounds between(Integer bound1, Integer bound2) {
        return new IntBounds(bound1, bound2);
    }

    public static IntBounds of(Integer bound) {
        return IntBounds.between(bound, bound);
    }

    public static IntBounds of(IBounds<? extends Number> bounds) {
        return IntBounds.between(bounds.getMin().intValue(), bounds.getMax().intValue());
    }

    @Override
    public final Integer getMin() {
        return this.min;
    }

    @Override
    public final Integer getMax() {
        return this.max;
    }

    @Override
    public boolean encloses(Integer value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    @Override
    public Integer enclose(Integer value) {
        return CommonMath.Range.enclose(value, this.getMin(), this.getMax());
    }

    @Override
    public Integer randomBetween() {
        return CommonMath.Random.between(this.getMin(), this.getMax());
    }

    @Override
    public Integer randomBetween(Random random) {
        return CommonMath.Random.between(this.getMin(), this.getMax(), random);
    }

    @Override
    public Integer interpolateUp(float factor) {
        return CommonMath.Interpolation.strictUp(factor, this);
    }

    @Override
    public Integer interpolateDown(float factor) {
        return CommonMath.Interpolation.strictDown(factor, this);
    }

    @Override
    public float interpolationFactor(Integer value) {
        return CommonMath.notZero(this.length().intValue()) ? (float)(value - this.getMin()) / (float)this.length().intValue() : 0.0f;
    }

    @Override
    public Integer length() {
        return this.getMax() - this.getMin();
    }

    @Override
    public Integer center() {
        return this.getMin() + this.length() / 2;
    }

    public IntBounds reduce(Integer value) {
        return IntBounds.between(this.getMin() + value, this.getMax() - value);
    }

    public IntBounds extend(Integer value) {
        return IntBounds.between(this.getMin() - value, this.getMax() + value);
    }

    public IntBounds offset(Integer value) {
        return IntBounds.between(this.getMin() + value, this.getMax() + value);
    }

    public IntBounds fit(IBounds<Integer> bounds) {
        return IntBounds.between(bounds.enclose(this.getMin()), bounds.enclose(this.getMax()));
    }

    @Override
    public boolean within(IBounds<Integer> bounds) {
        return bounds.encloses(this.getMin()) && bounds.encloses(this.getMax());
    }

    public IntBounds unite(IBounds<Integer> bounds) {
        return IntBounds.between(Math.min(this.getMin(), bounds.getMin()), Math.max(this.getMax(), bounds.getMax()));
    }

    public String toString() {
        return IntBounds.class.getSimpleName() + Args.group(Args.get("min", this.getMin()), Args.get("max", this.getMax()));
    }

    @Override
    public boolean randomFits(Integer value) {
        if (value >= this.getMax()) {
            return true;
        }
        if (value <= this.getMin()) {
            return false;
        }
        Integer random = this.randomBetween();
        return random <= value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntBounds) {
            IntBounds bounds = (IntBounds)obj;
            return this.getMin().equals(bounds.getMin()) && this.getMax().equals(bounds.getMax());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax());
    }

    @Override
    public boolean corners(Integer value) {
        return this.getMin().equals(value) || this.getMax().equals(value);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iter();
    }

    private class Iter
    implements Iterator<Integer> {
        Integer value;

        private Iter() {
            this.value = IntBounds.this.getMin() - 1;
        }

        @Override
        public boolean hasNext() {
            return IntBounds.this.encloses(this.value + 1);
        }

        @Override
        public Integer next() {
            Integer n = this.value;
            this.value = this.value + 1;
            return this.value;
        }
    }
}

