/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.SolarPanelConfig;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.screen.menu.SolarPanelMenu;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.energy.ExtractOnlyEnergyContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlockEntity
extends AbstractMachineBlockEntity
implements EnergyBlock {
    private ExtractOnlyEnergyContainer energyContainer;

    public SolarPanelBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.SOLAR_PANEL.get(), blockPos, blockState);
    }

    public static long getEnergyForDimension(Level level) {
        if (level != null) {
            return (long)((double)ModUtils.getSolarEnergy(level) * SolarPanelConfig.energyMultiplier);
        }
        return 0L;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new SolarPanelMenu(syncId, inv, this);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.m_5776_()) {
            if (this.f_58857_.m_46461_() && (!this.f_58857_.m_46472_().equals(Level.f_46428_) || !this.f_58857_.m_46471_() && !this.f_58857_.m_46470_()) && this.f_58857_.m_45527_(this.m_58899_().m_7494_())) {
                this.getEnergyStorage().internalInsert(this.getEnergyPerTick(), false);
                this.setActive(true);
            } else {
                this.setActive(false);
            }
            EnergyHooks.distributeEnergyNearby((BlockEntity)this, (long)this.getEnergyPerTick());
        }
    }

    public long getEnergyPerTick() {
        return SolarPanelBlockEntity.getEnergyForDimension(this.m_58904_());
    }

    public long getMaxCapacity() {
        return this.getEnergyStorage().getMaxCapacity();
    }

    public ExtractOnlyEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new ExtractOnlyEnergyContainer((Updatable)this, (long)((int)SolarPanelConfig.maxEnergy))) : this.energyContainer;
    }

    public void update() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

