/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UABiomeTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UABiomeModifierTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAFeatures;
import com.teamabnormals.upgrade_aquatic.core.registry.UAWorldCarvers;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class UABiomeModifierProvider {
    private static final RegistryAccess ACCESS = RegistryAccess.m_206197_();
    private static final Registry<Biome> BIOME_REGISTRY = ACCESS.m_175515_(Registry.f_122885_);
    private static final Registry<PlacedFeature> PLACED_FEATURES = ACCESS.m_175515_(Registry.f_194567_);
    private static final Registry<ConfiguredWorldCarver<?>> CARVERS = ACCESS.m_175515_(Registry.f_122880_);
    private static final HashMap<ResourceLocation, BiomeModifier> MODIFIERS = new HashMap();

    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        UABiomeModifierProvider.addFeature("beach_vegetation", (ResourceKey<Biome>)Biomes.f_48217_, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.PATCH_SEAROCKET, UAFeatures.UAPlacedFeatures.BEACHGRASS_DUNES);
        UABiomeModifierProvider.addFeature("river_tree", (TagKey<Biome>)BiomeTags.f_207605_, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.RIVER_TREE);
        UABiomeModifierProvider.addFeature("flowering_rush", (ResourceKey<Biome>)Biomes.f_48208_, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.PATCH_FLOWERING_RUSH);
        UABiomeModifierProvider.addFeature("pickerelweed", UABiomeTags.HAS_PICKERELWEED, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.PATCH_PICKERELWEED);
        UABiomeModifierProvider.addFeature("pickerelweed_extra", UABiomeTags.HAS_EXTRA_PICKERELWEED, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.PATCH_PICKERELWEED_EXTRA);
        UABiomeModifierProvider.addFeature("ammonite_ore", UABiomeTags.HAS_AMMONITE_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, UAFeatures.UAPlacedFeatures.ORE_AMMONITE);
        UABiomeModifierProvider.addFeature("prismarine_coral", (TagKey<Biome>)BiomeTags.f_207603_, GenerationStep.Decoration.RAW_GENERATION, UAFeatures.UAPlacedFeatures.PRISMARINE_CORAL);
        UABiomeModifierProvider.addFeature("driftwood", (TagKey<Biome>)BiomeTags.f_207603_, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_OCEAN);
        UABiomeModifierProvider.addFeature("driftwood_beach", (TagKey<Biome>)BiomeTags.f_207604_, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_BEACH);
        UABiomeModifierProvider.addFeature("driftwood_river", (TagKey<Biome>)BiomeTags.f_207605_, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_RIVER);
        UABiomeModifierProvider.addFeature("driftwood_swamp", (TagKey<Biome>)Tags.Biomes.IS_SWAMP, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_SWAMP);
        UABiomeModifierProvider.addFeature("driftwood_extra", UABiomeTags.HAS_EXTRA_DRIFTWOOD, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_EXTRA);
        UABiomeModifierProvider.addCarver("underwater_canyon", (TagKey<Biome>)BiomeTags.f_207603_, GenerationStep.Carving.AIR, UAWorldCarvers.UAConfiguredWorldCarvers.UNDERWATER_CANYON);
        UABiomeModifierProvider.addSpawn("thrasher", UABiomeTags.HAS_THRASHER, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.THRASHER.get(), 10, 1, 2));
        UABiomeModifierProvider.addSpawn("nautilus", UABiomeTags.HAS_NAUTILUS, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.NAUTILUS.get(), 50, 1, 4));
        UABiomeModifierProvider.addSpawn("lionfish", UABiomeTags.HAS_LIONFISH, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.LIONFISH.get(), 15, 1, 1));
        UABiomeModifierProvider.addSpawn("pike", UABiomeTags.HAS_PIKE, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.PIKE.get(), 20, 1, 2));
        UABiomeModifierProvider.addSpawn("squid", UABiomeTags.HAS_SQUID, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 5, 1, 2));
        UABiomeModifierProvider.addSpawn("pike_extra", UABiomeTags.HAS_EXTRA_PIKE, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.PIKE.get(), 10, 1, 2));
        UABiomeModifierProvider.addSpawn("perch", UABiomeTags.HAS_PERCH, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.PERCH.get(), 5, 1, 6));
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"upgrade_aquatic", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)ACCESS), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, MODIFIERS);
    }

    @SafeVarargs
    private static void addFeature(String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        UABiomeModifierProvider.addFeature(name, UABiomeModifierProvider.biomeSet(biome), step, features);
    }

    @SafeVarargs
    private static void addFeature(String name, TagKey<Biome> biomes, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        UABiomeModifierProvider.addFeature(name, (HolderSet<Biome>)new HolderSet.Named(BIOME_REGISTRY, biomes), step, features);
    }

    @SafeVarargs
    private static void addFeature(String name, HolderSet<Biome> biomes, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        UABiomeModifierProvider.addModifier("add_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomes, UABiomeModifierProvider.featureSet(features), step));
    }

    @SafeVarargs
    private static void addCarver(String name, TagKey<Biome> tagKey, GenerationStep.Carving step, RegistryObject<ConfiguredWorldCarver<?>> ... carvers) {
        UABiomeModifierProvider.addModifier("add_carver/" + name, new UABiomeModifierTypes.AddCarversBiomeModifier((HolderSet<Biome>)new HolderSet.Named(BIOME_REGISTRY, tagKey), UABiomeModifierProvider.carverSet(carvers), step));
    }

    private static void addSpawn(String name, TagKey<Biome> tagKey, MobSpawnSettings.SpawnerData ... spawns) {
        UABiomeModifierProvider.addModifier("add_spawn/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)new HolderSet.Named(BIOME_REGISTRY, tagKey), List.of(spawns)));
    }

    private static void addModifier(String name, BiomeModifier modifier) {
        MODIFIERS.put(new ResourceLocation("upgrade_aquatic", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<Biome> biomeSet(ResourceKey<Biome> ... biomes) {
        return HolderSet.m_205800_(Stream.of(biomes).map(arg_0 -> BIOME_REGISTRY.m_214121_(arg_0)).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> PLACED_FEATURES.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static HolderSet<ConfiguredWorldCarver<?>> carverSet(RegistryObject<ConfiguredWorldCarver<?>> ... carvers) {
        return HolderSet.m_205800_(Stream.of(carvers).map(registryObject -> CARVERS.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }
}

