/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal;

import com.teamabnormals.blueprint.common.entity.BucketableWaterAnimal;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Lionfish
extends BucketableWaterAnimal {
    private static final Predicate<LivingEntity> ENEMY_MATCHER = entity -> {
        if (entity == null) {
            return false;
        }
        return !(entity instanceof Lionfish) && !(entity instanceof AbstractFish);
    };
    private static final EntityDataAccessor<Boolean> HUNGY = SynchedEntityData.m_135353_(Lionfish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIME_TILL_HUNGRY = SynchedEntityData.m_135353_(Lionfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int lastTimeSinceHungry;

    public Lionfish(EntityType<? extends Lionfish> type, Level world) {
        super((EntityType)UAEntityTypes.LIONFISH.get(), world);
        this.f_21342_ = new MoveHelperController(this);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.35, 30){

            public boolean m_8036_() {
                Vec3 vec3d;
                if (this.f_25725_.m_20160_()) {
                    return false;
                }
                if (!this.f_25731_) {
                    if (this.f_25725_.m_21216_() >= 100) {
                        return false;
                    }
                    if (((Lionfish)this.f_25725_).isHungry() ? this.f_25725_.m_217043_().m_188503_(60) != 0 : this.f_25725_.m_217043_().m_188503_(30) != 0) {
                        return false;
                    }
                }
                if ((vec3d = this.m_7037_()) == null) {
                    return false;
                }
                this.f_25726_ = vec3d.f_82479_;
                this.f_25727_ = vec3d.f_82480_;
                this.f_25728_ = vec3d.f_82481_;
                this.f_25731_ = false;
                return true;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new LionfishAttackGoal((PathfinderMob)this, 12.0, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<TropicalFish>((Mob)this, TropicalFish.class, true){

            public boolean m_8036_() {
                return ((Lionfish)this.f_26135_).isHungry() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HUNGY, (Object)true);
        this.f_19804_.m_135372_(TIME_TILL_HUNGRY, (Object)0);
    }

    public boolean isHungry() {
        return (Boolean)this.f_19804_.m_135370_(HUNGY);
    }

    public void setHungry(boolean hungry) {
        this.f_19804_.m_135381_(HUNGY, (Object)hungry);
    }

    public int getTimeTillHungry() {
        return (Integer)this.f_19804_.m_135370_(TIME_TILL_HUNGRY);
    }

    public void setTimeTillHungry(int ticks) {
        this.f_19804_.m_135381_(TIME_TILL_HUNGRY, (Object)ticks);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsHungry", this.isHungry());
        compound.m_128405_("TimeTillHungry", this.getTimeTillHungry());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHungry(compound.m_128471_("IsHungry"));
        this.setTimeTillHungry(compound.m_128451_("TimeTillHungry"));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.85f;
    }

    public int m_5792_() {
        return 3;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.LIONFISH_SPAWN_EGG.get());
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)UAItems.LIONFISH_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public static boolean checkLionfishSpawnRules(EntityType<? extends Entity> entityType, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        for (int yy = pos.m_123342_() - 2; yy <= pos.m_123342_() + 2; ++yy) {
            for (int xx = pos.m_123341_() - 6; xx <= pos.m_123341_() + 6; ++xx) {
                for (int zz = pos.m_123343_() - 6; zz <= pos.m_123343_() + 6; ++zz) {
                    if (!world.m_8055_(new BlockPos(xx, yy, zz)).m_204336_(BlockTags.f_13051_)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20069_() && this.f_19861_ && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.035f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.035f)));
            this.f_19861_ = false;
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        if (this.m_6084_()) {
            for (LivingEntity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(0.3), ENEMY_MATCHER)) {
                if (!entity.m_6084_()) continue;
                this.attack(entity);
            }
        }
        if (!this.isHungry() && this.lastTimeSinceHungry < this.getTimeTillHungry()) {
            ++this.lastTimeSinceHungry;
        }
        if (this.lastTimeSinceHungry >= this.getTimeTillHungry()) {
            this.setHungry(true);
            this.lastTimeSinceHungry = 0;
        }
    }

    private void attack(LivingEntity entity) {
        if (entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f) && entity.m_20069_()) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 70, 1));
            this.m_5496_(SoundEvents.f_12295_, 1.0f, 1.0f);
            if (entity instanceof Player) {
                this.m_6710_(entity);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entitySource = source.m_7639_();
        if (entitySource instanceof LivingEntity && (!(entitySource instanceof Player) || !((Player)entitySource).m_150110_().f_35937_) && entitySource instanceof Player) {
            this.m_6710_((LivingEntity)entitySource);
        }
        return super.m_6469_(source, amount);
    }

    public void m_7023_(Vec3 p_213352_1_) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.01f, p_213352_1_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_213352_1_);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12289_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12292_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12294_;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12293_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Lionfish lionfish;

        MoveHelperController(Lionfish lionfish) {
            super((Mob)lionfish);
            this.lionfish = lionfish;
        }

        public void m_8126_() {
            if (this.lionfish.m_204029_(FluidTags.f_13131_)) {
                this.lionfish.m_20256_(this.lionfish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.lionfish.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.lionfish.m_20185_();
                double d1 = this.f_24976_ - this.lionfish.m_20186_();
                double d2 = this.f_24977_ - this.lionfish.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.lionfish.m_146922_(this.m_24991_(this.lionfish.m_146908_(), f, 90.0f));
                this.lionfish.f_20883_ = this.lionfish.m_146908_();
                float f1 = (float)(this.f_24978_ * this.lionfish.m_21051_(Attributes.f_22279_).m_22135_());
                this.lionfish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.lionfish.m_6113_(), (float)f1));
                this.lionfish.m_20256_(this.lionfish.m_20184_().m_82520_(0.0, (double)this.lionfish.m_6113_() * d1 * 0.03, 0.0));
            }
        }
    }

    static class LionfishAttackGoal
    extends MeleeAttackGoal {
        public LionfishAttackGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.f_25540_.m_20069_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                ((Lionfish)this.f_25540_).attack(enemy);
                ((Lionfish)this.f_25540_).setHungry(false);
                ((Lionfish)this.f_25540_).setTimeTillHungry(this.f_25540_.m_217043_().m_188503_(300) + 300);
                if (enemy instanceof Player) {
                    this.f_25540_.m_6710_(null);
                    this.m_8041_();
                }
            }
        }
    }
}

