/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;

public abstract class ButtonListBaseScreen
extends BaseScreen {
    private final Panel panelButtons;
    private final PanelScrollBar scrollBar;
    private Component title = Component.m_237119_();
    private final TextBox searchBox;
    private boolean hasSearchBox;
    private int borderH;
    private int borderV;
    private int borderW;

    public ButtonListBaseScreen() {
        this.panelButtons = new Panel(this){

            @Override
            public void add(Widget widget) {
                if (!ButtonListBaseScreen.this.hasSearchBox || ButtonListBaseScreen.this.searchBox.getText().isEmpty() || ButtonListBaseScreen.this.getFilterText(widget).contains(ButtonListBaseScreen.this.searchBox.getText().toLowerCase())) {
                    super.add(widget);
                }
            }

            @Override
            public void addWidgets() {
                ButtonListBaseScreen.this.addButtons(this);
            }

            @Override
            public void alignWidgets() {
                this.setY(ButtonListBaseScreen.this.hasSearchBox ? 23 : 9);
                int prevWidth = this.width;
                if (this.widgets.isEmpty()) {
                    this.setWidth(100);
                } else {
                    this.setWidth(100);
                    for (Widget w : this.widgets) {
                        this.setWidth(Math.max(this.width, w.width));
                    }
                }
                if (this.width > ButtonListBaseScreen.this.width - 40) {
                    this.width = ButtonListBaseScreen.this.width - 40;
                }
                if (ButtonListBaseScreen.this.hasSearchBox) {
                    this.setWidth(Math.max(this.width, prevWidth));
                }
                for (Widget w : this.widgets) {
                    w.setX(ButtonListBaseScreen.this.borderH);
                    w.setWidth(this.width - ButtonListBaseScreen.this.borderH * 2);
                }
                this.setHeight(140);
                ButtonListBaseScreen.this.scrollBar.setPosAndSize(this.posX + this.width + 6, this.posY - 1, 16, this.height + 2);
                ButtonListBaseScreen.this.scrollBar.setMaxValue(this.align(new WidgetLayout.Vertical(ButtonListBaseScreen.this.borderV, ButtonListBaseScreen.this.borderW, ButtonListBaseScreen.this.borderV)));
                this.getGui().setWidth(ButtonListBaseScreen.this.scrollBar.posX + ButtonListBaseScreen.this.scrollBar.width + 8);
                this.getGui().setHeight(this.height + 18 + (ButtonListBaseScreen.this.hasSearchBox ? 14 : 0));
                if (ButtonListBaseScreen.this.hasSearchBox) {
                    ButtonListBaseScreen.this.searchBox.setPosAndSize(8, 6, this.getGui().width - 16, 12);
                }
            }

            @Override
            public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
                theme.drawPanelBackground(matrixStack, x, y, w, h);
            }
        };
        this.panelButtons.setPosAndSize(9, 9, 0, 146);
        this.scrollBar = new PanelScrollBar(this, this.panelButtons);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(20.0);
        this.searchBox = new TextBox(this){

            @Override
            public void onTextChanged() {
                ButtonListBaseScreen.this.panelButtons.refreshWidgets();
            }
        };
        this.searchBox.ghostText = I18n.m_118938_((String)"gui.search_box", (Object[])new Object[0]);
        this.hasSearchBox = false;
    }

    public void setHasSearchBox(boolean v) {
        if (this.hasSearchBox != v) {
            this.hasSearchBox = v;
            this.refreshWidgets();
        }
    }

    public String getFilterText(Widget widget) {
        return widget.getTitle().getString().toLowerCase();
    }

    @Override
    public void addWidgets() {
        this.add(this.panelButtons);
        this.add(this.scrollBar);
        if (this.hasSearchBox) {
            this.add(this.searchBox);
        }
    }

    @Override
    public void alignWidgets() {
        this.panelButtons.alignWidgets();
    }

    public abstract void addButtons(Panel var1);

    public void setTitle(Component txt) {
        this.title = txt;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    public void setBorder(int h, int v, int w) {
        this.borderH = h;
        this.borderV = v;
        this.borderW = w;
    }

    @Override
    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        Component title = this.getTitle();
        if (title.m_214077_() != ComponentContents.f_237124_) {
            theme.drawString(matrixStack, title, x + (this.width - theme.getStringWidth((FormattedText)title)) / 2, y - theme.getFontHeight() - 2, 2);
        }
    }

    public void focus() {
        this.searchBox.setFocused(true);
    }
}

