/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.util;

import com.legacy.structure_gel.core.StructureGelMod;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Deprecated(forRemoval=true, since="1.19.2")
public abstract class AbstractConfigUtil {
    protected final String name;
    private final Supplier<ForgeConfigSpec> configSpec;

    public AbstractConfigUtil(String name, Supplier<ForgeConfigSpec> configSpec) {
        this.name = name;
        this.configSpec = configSpec;
        if (FMLJavaModLoadingContext.get() != null) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            bus.addListener(this::onConfigLoad);
            bus.addListener(this::onConfigReload);
        }
    }

    protected void onConfigLoad(ModConfigEvent.Loading event) {
        this.handleLoad();
    }

    protected void onConfigReload(ModConfigEvent.Reloading event) {
        this.handleLoad();
    }

    protected void handleLoad() {
        CompletableFuture.runAsync(() -> {
            int maxAttempts = 50;
            int attempts = 0;
            while (attempts < maxAttempts) {
                if (this.configSpec.get().isLoaded()) {
                    ++attempts;
                    this.reload();
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    StructureGelMod.LOGGER.error(e, new Object[0]);
                }
            }
            if (attempts >= maxAttempts) {
                StructureGelMod.LOGGER.error("Couldn't load the config file. Max attempts reached.", new Object[0]);
            }
        });
    }

    @Deprecated
    protected abstract void reload();

    @Deprecated
    protected String configComment(String description, Object defaultVal, Object example) {
        return String.format("\n %s\n Example: %s\n Default: %s", description, this.valString(example), this.valString(defaultVal));
    }

    @Deprecated
    protected String configComment(String description, Object defaultVal) {
        return String.format("\n %s\n Default: %s", description, this.valString(defaultVal));
    }

    protected String valString(Object val) {
        if (val instanceof List) {
            List list = (List)val;
            if (list.isEmpty()) {
                return "[]";
            }
            return "[\"" + String.join((CharSequence)"\", \"", list.stream().map(Object::toString).collect(Collectors.toList())) + "\"]";
        }
        return val.toString();
    }

    protected void logResourceLocationError(String invalidResourceLocation, String message) {
        StructureGelMod.LOGGER.error("Couldn't read a ResourceLocation in the config for {}. It was {}. {}", this.name, invalidResourceLocation, message);
    }
}

