/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin;

import com.legacy.structure_gel.api.structure.GridStructurePlacement;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public class ChunkGeneratorMixin {
    @Inject(at={@At(value="HEAD")}, method={"findNearestMapStructure"}, cancellable=true)
    private void stopIfNotInDimension(ServerLevel serverLevel, HolderSet<Structure> structures, BlockPos origin, int radius, boolean skipKnownStructures, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> callback) {
        ResourceKey levelKey = serverLevel.m_46472_();
        if (structures.m_203614_().map(Holder::m_203543_).noneMatch(structure -> StructureAccessHelper.isValidDimension(structure, (ResourceKey<Level>)levelKey))) {
            callback.setReturnValue(null);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"findNearestMapStructure"}, cancellable=true)
    private void locateGelPlacement(ServerLevel serverLevel, HolderSet<Structure> structures, BlockPos origin, int radius, boolean skipKnownStructures, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> callback) {
        Pair<BlockPos, Holder<Structure>> newNearest = GridStructurePlacement.findNearesStructure(serverLevel, structures, origin, radius, skipKnownStructures, (ChunkGenerator)this, (Pair<BlockPos, Holder<Structure>>)((Pair)callback.getReturnValue()));
        if (newNearest != null) {
            callback.setReturnValue(newNearest);
        }
    }
}

