/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.moonlightconfigs.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigSpec;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigType;
import org.jetbrains.annotations.Nullable;

public class ConfigSpecWrapper
extends ConfigSpec {
    private final ForgeConfigSpec spec;
    private final ModConfig modConfig;

    public ConfigSpecWrapper(ResourceLocation name, ForgeConfigSpec spec, ConfigType type, boolean synced, @javax.annotation.Nullable Runnable onChange) {
        super(name, FMLPaths.CONFIGDIR.get(), type, synced, onChange);
        this.spec = spec;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (onChange != null) {
            bus.addListener(this::onConfigChange);
        }
        ModConfig.Type t = this.getConfigType() == ConfigType.COMMON ? ModConfig.Type.COMMON : ModConfig.Type.CLIENT;
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        this.modConfig = new ModConfig(t, (IConfigSpec)spec, modContainer, name.m_135827_() + "-" + name.m_135815_() + ".toml");
        ConfigSpec.addTrackedSpec(this);
    }

    @Override
    public String getFileName() {
        return this.modConfig.getFileName();
    }

    @Override
    public Path getFullPath() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getFileName());
    }

    @Override
    public void register() {
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        modContainer.addConfig(this.modConfig);
    }

    @Override
    public void loadFromFile() {
        CommentedFileConfig replacementConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.getFullPath()).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        replacementConfig.load();
        replacementConfig.save();
        this.spec.setConfig((CommentedConfig)replacementConfig);
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    @Nullable
    public ModConfig getModConfig() {
        return this.modConfig;
    }

    public ModConfig.Type getModConfigType() {
        return this.getConfigType() == ConfigType.CLIENT ? ModConfig.Type.CLIENT : ModConfig.Type.COMMON;
    }

    @Override
    public boolean isLoaded() {
        return this.spec.isLoaded();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen makeScreen(Screen parent, @Nullable ResourceLocation background) {
        Optional factory;
        Optional container = ModList.get().getModContainerById(this.getModId());
        if (container.isPresent() && (factory = ((ModContainer)container.get()).getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class)).isPresent()) {
            return (Screen)((ConfigScreenHandler.ConfigScreenFactory)factory.get()).screenFunction().apply(Minecraft.m_91087_(), parent);
        }
        return null;
    }

    @Override
    public boolean hasConfigScreen() {
        return ModList.get().getModContainerById(this.getModId()).map(container -> container.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).isPresent()).orElse(false);
    }

    protected void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec() == this.getSpec()) {
            this.onRefresh();
        }
    }

    @Override
    public void loadFromBytes(InputStream stream) {
        this.getSpec().setConfig((CommentedConfig)TomlFormat.instance().createParser().parse(stream));
        this.onRefresh();
    }

    @Override
    public void save() {
        this.spec.save();
        this.modConfig.save();
    }
}

