/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.fluid.utils;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class FluidIngredient
implements Predicate<FluidHolder> {
    private static final Codec<FluidIngredient> NEW_CODEC = Codec.either(FluidValue.CODEC, TagValue.CODEC).listOf().xmap(FluidIngredient::new, FluidIngredient::getRawValues);
    private static final Codec<FluidIngredient> OLD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(FluidValue.CODEC, TagValue.CODEC).listOf().fieldOf("fluids").forGetter(FluidIngredient::getRawValues)).apply((Applicative)instance, FluidIngredient::new));
    public static final Codec<FluidIngredient> CODEC = Codec.either(NEW_CODEC, OLD_CODEC).xmap(p -> (FluidIngredient)p.map(a -> a, b -> b), Either::left);
    private final List<Either<FluidValue, TagValue>> values;
    private List<FluidHolder> cachedFluids;

    private FluidIngredient(List<Either<FluidValue, TagValue>> stream) {
        this.values = stream;
    }

    public static FluidIngredient of() {
        return new FluidIngredient(List.of());
    }

    public static FluidIngredient of(Fluid ... fluids) {
        return FluidIngredient.of(Arrays.stream(fluids).map(FluidHolder::of));
    }

    public static FluidIngredient of(FluidHolder ... fluids) {
        return FluidIngredient.of(Arrays.stream(fluids));
    }

    public static FluidIngredient of(Stream<FluidHolder> fluids) {
        ArrayList<Either<FluidValue, TagValue>> values = new ArrayList<Either<FluidValue, TagValue>>();
        for (FluidHolder fluid : fluids.filter(Predicate.not(FluidHolder::isEmpty)).toList()) {
            values.add((Either<FluidValue, TagValue>)Either.left((Object)new FluidValue(fluid)));
        }
        return new FluidIngredient(values);
    }

    public static FluidIngredient of(TagKey<Fluid> tag) {
        return new FluidIngredient(List.of(Either.right((Object)new TagValue(tag))));
    }

    @Override
    public boolean test(FluidHolder fluidHolder) {
        if (this.values.isEmpty()) {
            return fluidHolder.isEmpty();
        }
        for (FluidHolder value : this.getFluids()) {
            if (!fluidHolder.getFluid().m_6212_(value.getFluid())) continue;
            return true;
        }
        return false;
    }

    public List<FluidHolder> getFluids() {
        this.dissolve();
        return this.cachedFluids;
    }

    public void dissolve() {
        if (this.cachedFluids == null) {
            this.cachedFluids = this.values.stream().flatMap(either -> (Stream)either.map(fluidValue -> Stream.of(fluidValue.fluid()), tagValue -> tagValue.getFluids().stream())).collect(Collectors.toList());
        }
    }

    public List<Either<FluidValue, TagValue>> getRawValues() {
        return this.values;
    }

    public record FluidValue(FluidHolder fluid) implements Value
    {
        private static final Codec<FluidValue> NEW_CODEC = FluidHolder.CODEC.orElse((Object)FluidHooks.emptyFluid()).xmap(FluidValue::new, FluidValue::fluid);
        private static final Codec<FluidValue> OLD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidHolder.CODEC.fieldOf("fluid").orElse((Object)FluidHooks.emptyFluid()).forGetter(FluidValue::fluid)).apply((Applicative)instance, FluidValue::new));
        public static final Codec<FluidValue> CODEC = Codec.either(NEW_CODEC, OLD_CODEC).xmap(p -> (FluidValue)p.map(a -> a, b -> b), Either::left);

        @Override
        public Collection<FluidHolder> getFluids() {
            return Collections.singleton(this.fluid);
        }
    }

    public record TagValue(TagKey<Fluid> tag) implements Value
    {
        public static final Codec<TagValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)Registry.f_122822_.m_123023_()).fieldOf("tag").forGetter(TagValue::tag)).apply((Applicative)instance, TagValue::new));

        @Override
        public Collection<FluidHolder> getFluids() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : Registry.f_122822_.m_206058_(this.tag)) {
                list.add(FluidHolder.of((Fluid)holder.m_203334_()));
            }
            return list;
        }
    }

    public static interface Value {
        public Collection<FluidHolder> getFluids();
    }
}

