/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;
import slimeknights.tconstruct.tools.recipe.ExtractModifierRecipe;

public class EnchantmentConvertingRecipe
extends AbstractWorktableRecipe {
    private static final Component DESCRIPTION_LOST = TConstruct.makeTranslation("recipe", "enchantment_converting.description.lost");
    private static final Component DESCRIPTION_KEEP = TConstruct.makeTranslation("recipe", "enchantment_converting.description.keep");
    private static final Component NO_ENCHANTMENT = TConstruct.makeTranslation("recipe", "enchantment_converting.no_enchantments");
    private static final RecipeResult<LazyToolStack> TOO_FEW = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "enchantment_converting.too_few"), new Object[0]);
    public static final RecordLoadable<EnchantmentConvertingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)StringLoadable.DEFAULT.requiredField("name", r -> r.name), (RecordField)INPUTS_FIELD, (RecordField)BooleanLoadable.INSTANCE.requiredField("match_book", r -> r.matchBook), (RecordField)BooleanLoadable.INSTANCE.requiredField("return_unenchanted", r -> r.returnInput), (RecordField)ModifierPredicate.LOADER.defaultField("modifier_predicate", false, r -> r.modifierPredicate), EnchantmentConvertingRecipe::new);
    private final String name;
    private final Component title;
    private final boolean matchBook;
    private final boolean returnInput;
    private final IJsonPredicate<ModifierId> modifierPredicate;
    private List<ModifierEntry> displayModifiers;
    private static List<ItemStack> ALL_ENCHANTABLE_TOOLS;

    public EnchantmentConvertingRecipe(ResourceLocation id, String name, List<SizedIngredient> inputs, boolean matchBook, boolean returnInput, IJsonPredicate<ModifierId> modifierPredicate) {
        super(id, inputs);
        this.name = name;
        this.title = Component.m_237115_((String)(ExtractModifierRecipe.BASE_KEY + "." + name));
        this.matchBook = matchBook;
        this.returnInput = returnInput;
        this.modifierPredicate = modifierPredicate;
    }

    private Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        return EnchantmentHelper.m_44882_((ListTag)(this.matchBook ? EnchantedBookItem.m_41163_((ItemStack)stack) : stack.m_41785_()));
    }

    @Override
    public Component getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && this.getEnchantments(inv.getTinkerableStack()).entrySet().stream().noneMatch(entry -> {
            Modifier modifier = ModifierManager.INSTANCE.get((Enchantment)entry.getKey());
            return modifier != null && this.modifierPredicate.matches((Object)modifier.getId());
        })) {
            return NO_ENCHANTMENT;
        }
        return this.returnInput ? DESCRIPTION_KEEP : DESCRIPTION_LOST;
    }

    @Override
    public boolean matches(ITinkerableContainer inv, Level world) {
        ItemStack tool = inv.getTinkerableStack();
        if (this.matchBook ? !tool.m_150930_(Items.f_42690_) : !tool.m_41720_().m_8120_(tool)) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv != null) {
            return this.getEnchantments(inv.getTinkerableStack()).entrySet().stream().map(entry -> {
                Modifier modifier = ModifierManager.INSTANCE.get((Enchantment)entry.getKey());
                if (modifier != null && this.modifierPredicate.matches((Object)modifier.getId())) {
                    return new ModifierEntry(modifier, this.returnInput ? 1 : (Integer)entry.getValue());
                }
                return null;
            }).filter(Objects::nonNull).distinct().toList();
        }
        if (this.displayModifiers == null) {
            this.displayModifiers = ModifierRecipeLookup.getAllRecipeModifiers().filter(modifier -> this.modifierPredicate.matches((Object)modifier.getId())).map(mod -> new ModifierEntry((Modifier)mod, 1)).toList();
        }
        return this.displayModifiers;
    }

    @Override
    public RecipeResult<LazyToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        int level = modifier.getLevel();
        if (level > 1) {
            int used = -1;
            block0: for (SizedIngredient ingredient : this.inputs) {
                for (int i = 0; i < inv.getInputCount(); ++i) {
                    ItemStack stack;
                    if (i == used || (stack = inv.getInput(i)).m_41619_() || ingredient.getAmountNeeded() * level > stack.m_41613_() || !ingredient.test(stack)) continue;
                    used = i;
                    continue block0;
                }
                return TOO_FEW;
            }
        }
        return RecipeResult.success(LazyToolStack.from(ModifierCrystalItem.withModifier(modifier.getId(), level)));
    }

    @Override
    public int shrinkToolSlotBy(LazyToolStack result) {
        return 1;
    }

    @Override
    public void updateInputs(LazyToolStack result, ITinkerableContainer.Mutable inv, ModifierEntry selected, boolean isServer) {
        for (int i = 0; i < selected.getLevel(); ++i) {
            ModifierRecipe.updateInputs(inv, this.inputs);
        }
        if (this.returnInput && isServer) {
            ItemStack unenchanted;
            ModifierId modifier = ModifierCrystalItem.getModifier(result.getStack());
            assert (modifier != null);
            ItemStack current = inv.getTinkerableStack();
            Map<Enchantment, Integer> enchantments = this.getEnchantments(current);
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                Enchantment enchantment = entry.getKey();
                Modifier enchantmentModifier = ModifierManager.INSTANCE.get(enchantment);
                if (enchantmentModifier == null || !enchantmentModifier.getId().equals((Object)modifier)) continue;
                int newLevel = entry.getValue() - 1;
                if (newLevel <= 0) {
                    enchantments.remove(enchantment);
                    break;
                }
                enchantments.put(enchantment, newLevel);
                break;
            }
            if (this.matchBook && enchantments.isEmpty()) {
                unenchanted = new ItemStack((ItemLike)Items.f_42517_);
                if (current.m_41788_()) {
                    unenchanted.m_41714_(current.m_41786_());
                }
            } else {
                unenchanted = current.m_41777_();
                if (this.matchBook) {
                    unenchanted.m_41749_("StoredEnchantments");
                }
                EnchantmentHelper.m_44865_(enchantments, (ItemStack)unenchanted);
            }
            inv.giveItem(unenchanted);
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.enchantmentConvertingSerializer.get();
    }

    @Override
    public boolean isModifierOutput() {
        return true;
    }

    @Override
    public List<ItemStack> getInputTools() {
        if (!this.matchBook) {
            return EnchantmentConvertingRecipe.getAllEnchantableTools();
        }
        if (this.tools == null) {
            Set modifiers = this.getModifierOptions(null).stream().map(ModifierEntry::getId).collect(Collectors.toSet());
            this.tools = ModifierManager.INSTANCE.getEquivalentEnchantments(modifiers::contains).flatMap(enchantment -> IntStream.rangeClosed(1, enchantment.m_6586_()).mapToObj(level -> EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level)))).toList();
        }
        return this.tools;
    }

    private static List<ItemStack> getAllEnchantableTools() {
        if (ALL_ENCHANTABLE_TOOLS == null) {
            ALL_ENCHANTABLE_TOOLS = ForgeRegistries.ITEMS.getValues().stream().map(item -> {
                ItemStack stack;
                if (item != Items.f_42517_ && (stack = new ItemStack((ItemLike)item)).m_41792_()) {
                    return stack;
                }
                return ItemStack.f_41583_;
            }).filter(stack -> !stack.m_41619_()).toList();
        }
        return ALL_ENCHANTABLE_TOOLS;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }
}

