/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.ranged;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.recipe.helper.TagPreference;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.shared.TinkerMaterials;

public class OlympicModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ProjectileHitModifierHook {
    private static final ResourceLocation OLYMPIC_START = TConstruct.getResource("olympic_start");
    private static final TagKey<Item> PLATINUM_NUGGET = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "nuggets/platinum"));

    private static Item getNugget(double distanceSq) {
        if (distanceSq > 2500.0) {
            return TagPreference.getPreference(PLATINUM_NUGGET).orElse(TinkerMaterials.cobalt.getNugget());
        }
        if (distanceSq > 1600.0) {
            return Items.f_42587_;
        }
        if (distanceSq > 900.0) {
            return Items.f_42749_;
        }
        if (distanceSq > 400.0) {
            return (Item)TinkerMaterials.copperNugget.get();
        }
        return Items.f_41852_;
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_HIT);
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("X", shooter.m_20185_());
        tag.m_128347_("Y", shooter.m_20186_());
        tag.m_128347_("Z", shooter.m_20189_());
        persistentData.put(OLYMPIC_START, (Tag)tag);
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        Item nugget;
        CompoundTag startCompound;
        Entity targetEntity = hit.m_82443_();
        if (!projectile.f_19853_.f_46443_ && targetEntity.m_6095_().m_20674_() == MobCategory.MONSTER && RANDOM.nextInt(20) < modifier.getLevel() && !(startCompound = persistentData.getCompound(OLYMPIC_START)).m_128456_() && startCompound.m_128425_("X", 99) && startCompound.m_128425_("Y", 99) && startCompound.m_128425_("Z", 99) && (nugget = OlympicModifier.getNugget(targetEntity.m_20275_(startCompound.m_128459_("X"), startCompound.m_128459_("Y"), startCompound.m_128459_("Z")))) != Items.f_41852_) {
            targetEntity.m_19998_((ItemLike)nugget);
            if (attacker != null) {
                projectile.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return false;
    }
}

