/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.armor.EffectImmunityModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorStatModule;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.modules.ranged.RestrictAngleModule;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierEvents {
    private static final String SOULBOUND_SLOT = "tic_soulbound_slot";
    private static final TinkerDataCapability.TinkerDataKey<Float> PROJECTILE_EXPERIENCE = TConstruct.createKey("projectile_experience");
    public static final ResourceLocation SOULBOUND = TConstruct.getResource("soulbound");
    private static final TinkerDataCapability.TinkerDataKey<Boolean> WAS_KNOCKBACK = TConstruct.createKey("was_knockback");

    @SubscribeEvent
    static void onKnockback(LivingKnockBackEvent event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            int crystalbound;
            float knockback = data.get(TinkerDataKeys.KNOCKBACK, Float.valueOf(0.0f)).floatValue();
            if (knockback != 0.0f) {
                event.setStrength(event.getStrength() * (1.0f + knockback));
            }
            if ((crystalbound = data.get(TinkerDataKeys.CRYSTALSTRIKE, 0).intValue()) > 0) {
                RestrictAngleModule.onKnockback(event, crystalbound);
            }
        });
    }

    @SubscribeEvent
    static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        float boost = ArmorStatModule.getStat((Entity)entity, TinkerDataKeys.JUMP_BOOST);
        if (boost > 0.0f) {
            event.setDistance(Math.max(event.getDistance() - boost, 0.0f));
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        float boost = ArmorStatModule.getStat((Entity)entity, TinkerDataKeys.JUMP_BOOST);
        if (boost > 0.0f) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)boost * 0.1, 0.0));
        }
    }

    @SubscribeEvent
    static void isPotionApplicable(MobEffectEvent.Applicable event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            if (((Multiset)data.computeIfAbsent(EffectImmunityModule.EFFECT_IMMUNITY)).contains((Object)event.getEffectInstance().m_19544_())) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        Projectile projectile;
        ModifierNBT modifiers;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.m_7640_()) instanceof Projectile && !(modifiers = EntityModifierCapability.getOrEmpty((Entity)(projectile = (Projectile)entity))).isEmpty()) {
            event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(PROJECTILE_EXPERIENCE, Float.valueOf(modifiers.getEntry(ModifierIds.experienced).getEffectiveLevel())));
        }
        LivingEntity entity2 = event.getEntity();
        if (!entity2.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && entity2 instanceof Player && !((player = (Player)entity2) instanceof FakePlayer)) {
            boolean soulBelt = ArmorLevelModule.getLevel((LivingEntity)player, TinkerDataKeys.SOUL_BELT) > 0;
            Inventory inventory = player.m_150109_();
            int hotbarSize = Inventory.m_36059_();
            for (int i = 0; i < hotbarSize; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !soulBelt && !ModifierUtil.checkVolatileFlag(stack, SOULBOUND)) continue;
                stack.m_41784_().m_128405_(SOULBOUND_SLOT, i);
            }
            int totalSize = inventory.m_6643_();
            for (int i = hotbarSize; i < totalSize; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !ModifierUtil.checkVolatileFlag(stack, SOULBOUND)) continue;
                stack.m_41784_().m_128405_(SOULBOUND_SLOT, i);
            }
        }
    }

    private static int boost(int original, float bonus) {
        return (int)((float)original * (1.0f + bonus));
    }

    @SubscribeEvent
    static void beforeBlockBreak(BlockEvent.BreakEvent event) {
        float bonus = ArmorStatModule.getStat((Entity)event.getPlayer(), TinkerDataKeys.EXPERIENCE);
        if (bonus != 0.0f) {
            event.setExpToDrop(ModifierEvents.boost(event.getExpToDrop(), bonus));
        }
    }

    @SubscribeEvent
    static void onExperienceDrop(LivingExperienceDropEvent event) {
        ToolStack tool;
        float boost;
        float projectileBoost;
        float armorBoost = 0.0f;
        Player player = event.getAttackingPlayer();
        if (player != null) {
            armorBoost = ArmorStatModule.getStat((Entity)player, TinkerDataKeys.EXPERIENCE);
        }
        if ((projectileBoost = event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> data.get(PROJECTILE_EXPERIENCE)).orElse(Float.valueOf(-1.0f)).floatValue()) > 0.0f) {
            event.setDroppedExperience(ModifierEvents.boost(event.getDroppedExperience(), projectileBoost * 0.5f + armorBoost));
        } else if (projectileBoost != 0.0f && player != null && (boost = ((tool = Modifier.getHeldTool((LivingEntity)player, ModifierLootingHandler.getLootingSlot((LivingEntity)player))) != null ? tool.getModifier(ModifierIds.experienced).getEffectiveLevel() : 0.0f) * 0.5f + armorBoost) > 0.0f) {
            event.setDroppedExperience(ModifierEvents.boost(event.getDroppedExperience(), boost));
        }
    }

    @SubscribeEvent
    static void onPlayerDropItems(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!(entity instanceof FakePlayer)) {
                Collection drops = event.getDrops();
                Iterator iter = drops.iterator();
                Inventory inventory = player.m_150109_();
                ArrayList<ItemEntity> takenSlot = new ArrayList<ItemEntity>();
                while (iter.hasNext()) {
                    ItemEntity itemEntity = (ItemEntity)iter.next();
                    ItemStack stack = itemEntity.m_32055_();
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null || !tag.m_128425_(SOULBOUND_SLOT, 99)) continue;
                    int slot = tag.m_128451_(SOULBOUND_SLOT);
                    if (inventory.m_8020_(slot).m_41619_()) {
                        inventory.m_6836_(slot, stack);
                    } else {
                        takenSlot.add(itemEntity);
                    }
                    iter.remove();
                }
                for (ItemEntity itemEntity : takenSlot) {
                    ItemStack stack = itemEntity.m_32055_();
                    if (inventory.m_36054_(stack)) continue;
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        tag.m_128473_(SOULBOUND_SLOT);
                        if (tag.m_128456_()) {
                            stack.m_41751_(null);
                        }
                    }
                    drops.add(itemEntity);
                }
            }
        }
    }

    @SubscribeEvent
    static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        if (clone.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) || original.m_5833_()) {
            return;
        }
        Inventory originalInv = original.m_150109_();
        Inventory cloneInv = clone.m_150109_();
        int size = Math.min(originalInv.m_6643_(), cloneInv.m_6643_());
        for (int i = 0; i < size; ++i) {
            CompoundTag tag;
            ItemStack stack = originalInv.m_8020_(i);
            if (stack.m_41619_() || (tag = stack.m_41783_()) == null || !tag.m_128425_(SOULBOUND_SLOT, 99)) continue;
            cloneInv.m_6836_(i, stack);
            tag.m_128473_(SOULBOUND_SLOT);
            if (!tag.m_128456_()) continue;
            stack.m_41751_(null);
        }
    }

    @SubscribeEvent
    static void onCritical(CriticalHitEvent event) {
        Player living;
        float criticalBoost;
        if (event.getResult() != Event.Result.DENY && (criticalBoost = ArmorStatModule.getStat((Entity)(living = event.getEntity()), TinkerDataKeys.CRITICAL_DAMAGE)) > 0.0f) {
            boolean isCritical;
            boolean bl = isCritical = event.isVanillaCritical() || event.getResult() == Event.Result.ALLOW;
            if (!isCritical && TinkerPredicate.AIRBORNE.matches((Object)living)) {
                isCritical = true;
                event.setResult(Event.Result.ALLOW);
            }
            if (isCritical) {
                event.setDamageModifier(event.getDamageModifier() + criticalBoost);
            }
        }
    }

    @SubscribeEvent
    static void onPotionStart(MobEffectEvent.Added event) {
        MobEffectInstance newEffect = event.getEffectInstance();
        if (!newEffect.getCurativeItems().isEmpty()) {
            LivingEntity living = event.getEntity();
            float boost = ArmorStatModule.getStat((Entity)event.getEntity(), newEffect.m_19544_().m_19486_() ? TinkerDataKeys.GOOD_EFFECT_DURATION : TinkerDataKeys.BAD_EFFECT_DURATION);
            if (boost != 0.0f) {
                int duration = (int)((float)newEffect.m_19557_() * (1.0f + boost));
                if (duration < 0) {
                    duration = 0;
                }
                newEffect.f_19503_ = duration;
            }
        }
    }

    @SubscribeEvent
    static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        Vec3 center = explosion.getPosition();
        float diameter = explosion.f_46017_ * 2.0f;
        for (Entity entity : event.getAffectedEntities()) {
            double x = entity.m_20185_() - center.f_82479_;
            double z = entity.m_20189_() - center.f_82481_;
            if ((entity.m_6128_() || x == 0.0) && z == 0.0 && entity.m_20188_() - center.f_82480_ == 0.0) continue;
            entity.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                double y;
                double distance;
                float explosionKnockback = data.get(TinkerDataKeys.EXPLOSION_KNOCKBACK, Float.valueOf(0.0f)).floatValue();
                if (explosionKnockback != 0.0f && (distance = (double)(Mth.m_14116_((float)((float)(x * x + (y = entity.m_20186_() - center.f_82480_) * y + z * z))) / diameter)) <= 1.0) {
                    data.put(WAS_KNOCKBACK, true);
                }
            });
        }
    }

    @SubscribeEvent
    static void livingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity living = event.getEntity();
        if (!living.f_19853_.f_46443_ && !living.m_5833_()) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                if (data.get(WAS_KNOCKBACK, false).booleanValue()) {
                    data.remove(WAS_KNOCKBACK);
                    float explosionKnockback = data.get(TinkerDataKeys.EXPLOSION_KNOCKBACK, Float.valueOf(0.0f)).floatValue();
                    if (explosionKnockback != 0.0f) {
                        double scale = 1.0f + explosionKnockback;
                        if (scale <= 0.0) {
                            living.m_20256_(Vec3.f_82478_);
                        } else {
                            living.m_20256_(living.m_20184_().m_82542_(scale, scale, scale));
                        }
                        living.f_19864_ = true;
                    }
                }
            });
        }
    }
}

