/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class StatsNBT {
    static final Set<String> ERRORED_IDS = new HashSet<String>();
    public static final StatsNBT EMPTY = new StatsNBT((Map<IToolStat<?>, Object>)ImmutableMap.of());
    private final Map<IToolStat<?>, Object> stats;
    public static final RecordLoadable<StatsNBT> LOADABLE = new RecordLoadable<StatsNBT>(){

        public StatsNBT deserialize(JsonObject json, TypedMap context) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : json.entrySet()) {
                IToolStat<?> stat = ToolStats.fromJson((String)entry.getKey());
                builder.put(stat, stat.deserialize((JsonElement)entry.getValue()));
            }
            return new StatsNBT((Map<IToolStat<?>, Object>)builder.build());
        }

        private static <T> JsonElement serialize(IToolStat<T> stat, Object value) {
            return stat.serialize(value);
        }

        public void serialize(StatsNBT stats, JsonObject json) {
            for (Map.Entry<IToolStat<?>, Object> entry : stats.stats.entrySet()) {
                IToolStat<?> stat = entry.getKey();
                json.add(stat.getName().toString(), 1.serialize(stat, entry.getValue()));
            }
        }

        public StatsNBT decode(FriendlyByteBuf buffer, TypedMap context) {
            return StatsNBT.fromNetwork(buffer);
        }

        public void encode(FriendlyByteBuf buffer, StatsNBT stats) {
            stats.toNetwork(buffer);
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    public Set<IToolStat<?>> getContainedStats() {
        return this.stats.keySet();
    }

    public boolean hasStat(IToolStat<?> stat) {
        return this.stats.containsKey(stat);
    }

    public <T> T get(IToolStat<T> stat) {
        return (T)this.stats.getOrDefault(stat, stat.getDefaultValue());
    }

    public int getInt(IToolStat<? extends Number> stat) {
        return this.get(stat).intValue();
    }

    @Nullable
    static IToolStat<?> readStatIdFromNBT(String name) {
        IToolStat<?> stat;
        ToolStatId statName = ToolStatId.tryParse(name);
        if (statName != null && (stat = ToolStats.getToolStat(statName)) != null) {
            return stat;
        }
        if (!ERRORED_IDS.contains(name)) {
            ERRORED_IDS.add(name);
            TConstruct.LOG.error("Ignoring unknown stat " + name + " in tool stat NBT");
        }
        return null;
    }

    public static StatsNBT readFromNBT(@Nullable Tag inbt) {
        if (inbt == null || inbt.m_7060_() != 10) {
            return EMPTY;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        CompoundTag nbt = (CompoundTag)inbt;
        for (String key : nbt.m_128431_()) {
            Object value;
            IToolStat<?> stat;
            Tag tag = nbt.m_128423_(key);
            if (tag == null || (stat = StatsNBT.readStatIdFromNBT(key)) == null || (value = stat.read(tag)) == null) continue;
            builder.put(stat, value);
        }
        return new StatsNBT((Map<IToolStat<?>, Object>)builder.build());
    }

    @Nullable
    private static <T> Tag serialize(IToolStat<T> stat, Object value) {
        return stat.write(value);
    }

    public CompoundTag serializeToNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<IToolStat<?>, Object> entry : this.stats.entrySet()) {
            IToolStat<?> stat = entry.getKey();
            Tag serialized = StatsNBT.serialize(stat, entry.getValue());
            if (serialized == null) continue;
            nbt.m_128365_(stat.getName().toString(), serialized);
        }
        return nbt;
    }

    private static <T> void toNetwork(FriendlyByteBuf buffer, IToolStat<T> stat, Object value) {
        stat.toNetwork(buffer, value);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.stats.size());
        for (Map.Entry<IToolStat<?>, Object> entry : this.stats.entrySet()) {
            IToolStat<?> stat = entry.getKey();
            buffer.m_130070_(stat.getName().toString());
            StatsNBT.toNetwork(buffer, stat, entry.getValue());
        }
    }

    public static StatsNBT fromNetwork(FriendlyByteBuf buffer) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int max = buffer.m_130242_();
        for (int i = 0; i < max; ++i) {
            IToolStat<?> stat = ToolStats.fromNetwork(buffer);
            builder.put(stat, stat.fromNetwork(buffer));
        }
        return new StatsNBT((Map<IToolStat<?>, Object>)builder.build());
    }

    StatsNBT(Map<IToolStat<?>, Object> stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatsNBT)) {
            return false;
        }
        StatsNBT other = (StatsNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<IToolStat<?>, Object> this$stats = this.stats;
        Map<IToolStat<?>, Object> other$stats = other.stats;
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatsNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<IToolStat<?>, Object> $stats = this.stats;
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    public String toString() {
        return "StatsNBT(stats=" + this.stats + ")";
    }

    public static class Builder {
        private final ImmutableMap.Builder<IToolStat<?>, Object> builder = ImmutableMap.builder();

        public <T> Builder set(IToolStat<T> stat, T value) {
            this.builder.put(stat, stat.clamp(value));
            return this;
        }

        public Builder set(INumericToolStat<Float> stat, float value) {
            return this.set((IToolStat)stat, (Object)Float.valueOf(value));
        }

        public StatsNBT build() {
            ImmutableMap map = this.builder.build();
            if (map.isEmpty()) {
                return EMPTY;
            }
            return new StatsNBT((Map<IToolStat<?>, Object>)map);
        }

        private Builder() {
        }
    }
}

