/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class MaterialIdNBT {
    public static final MaterialIdNBT EMPTY = new MaterialIdNBT((List<? extends MaterialVariantId>)ImmutableList.of());
    private final List<MaterialVariantId> materials;

    public MaterialIdNBT(List<? extends MaterialVariantId> materials) {
        this.materials = ImmutableList.copyOf(materials);
    }

    public MaterialVariantId getMaterial(int index) {
        if (index >= this.materials.size() || index < 0) {
            return IMaterial.UNKNOWN_ID;
        }
        return this.materials.get(index);
    }

    public MaterialIdNBT resolveRedirects() {
        boolean changed = false;
        ImmutableList.Builder builder = ImmutableList.builder();
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        for (MaterialVariantId id : this.materials) {
            MaterialId original = id.getId();
            MaterialId resolved = registry.resolve(original);
            if (resolved != original) {
                changed = true;
            }
            builder.add((Object)MaterialVariantId.create(resolved, id.getVariant()));
        }
        if (changed) {
            return new MaterialIdNBT((List<? extends MaterialVariantId>)builder.build());
        }
        return this;
    }

    public static MaterialIdNBT readFromNBT(@Nullable Tag nbt) {
        if (nbt == null || nbt.m_7060_() != 9) {
            return EMPTY;
        }
        ListTag listNBT = (ListTag)nbt;
        if (listNBT.m_7264_() != 8) {
            return EMPTY;
        }
        List materials = listNBT.stream().map(Tag::m_7916_).map(MaterialVariantId::tryParse).filter(Objects::nonNull).collect(Collectors.toList());
        return new MaterialIdNBT(materials);
    }

    public ListTag serializeToNBT() {
        return this.materials.stream().map(Object::toString).map(StringTag::m_129297_).collect(Collectors.toCollection(ListTag::new));
    }

    public static MaterialIdNBT from(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            return MaterialIdNBT.readFromNBT((Tag)nbt.m_128437_("tic_materials", 8));
        }
        return EMPTY;
    }

    public ItemStack updateStack(ItemStack stack) {
        stack.m_41784_().m_128365_("tic_materials", (Tag)this.serializeToNBT());
        return stack;
    }

    public CompoundTag updateNBT(CompoundTag nbt) {
        nbt.m_128365_("tic_materials", (Tag)this.serializeToNBT());
        return nbt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialIdNBT)) {
            return false;
        }
        MaterialIdNBT other = (MaterialIdNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<MaterialVariantId> this$materials = this.getMaterials();
        List<MaterialVariantId> other$materials = other.getMaterials();
        return !(this$materials == null ? other$materials != null : !((Object)this$materials).equals(other$materials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialIdNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MaterialVariantId> $materials = this.getMaterials();
        result = result * 59 + ($materials == null ? 43 : ((Object)$materials).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialIdNBT(materials=" + this.getMaterials() + ")";
    }

    public List<MaterialVariantId> getMaterials() {
        return this.materials;
    }
}

