/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialStatsModule;

record StatScaleField(String nestKey, String listKey) implements RecordField<float[], MaterialStatsModule>
{
    public float[] get(JsonObject json, TypedMap context) {
        JsonArray list = GsonHelper.m_13933_((JsonObject)json, (String)this.listKey);
        float[] scales = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            JsonElement element = list.get(i);
            scales[i] = element.isJsonObject() ? GsonHelper.m_13915_((JsonObject)element.getAsJsonObject(), (String)"scale") : 1.0f;
        }
        return scales;
    }

    public void serialize(MaterialStatsModule parent, JsonObject json) {
        JsonArray list = GsonHelper.m_13933_((JsonObject)json, (String)this.listKey);
        int size = Math.min(list.size(), parent.scales.length);
        for (int i = 0; i < size; ++i) {
            JsonObject object;
            float scale = parent.scales[i];
            if (scale == 1.0f) continue;
            JsonElement element = list.get(i);
            if (element.isJsonObject()) {
                object = element.getAsJsonObject();
            } else {
                object = new JsonObject();
                object.add(this.nestKey, element);
                list.set(i, (JsonElement)object);
            }
            object.addProperty("scale", (Number)Float.valueOf(scale));
        }
    }

    public float[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int size = buffer.m_130242_();
        float[] scales = new float[size];
        for (int i = 0; i < size; ++i) {
            scales[i] = buffer.readFloat();
        }
        return scales;
    }

    public void encode(FriendlyByteBuf buffer, MaterialStatsModule parent) {
        buffer.m_130130_(parent.scales.length);
        for (float scale : parent.scales) {
            buffer.writeFloat(scale);
        }
    }
}

