/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.material;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.field.OptionallyNestedLoadable;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialStatsModule;
import slimeknights.tconstruct.library.tools.definition.module.material.StatScaleField;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class PartStatsModule
extends MaterialStatsModule
implements ToolPartsHook {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.TOOL_STATS, ToolHooks.TOOL_TRAITS, ToolHooks.TOOL_MATERIALS, ToolHooks.TOOL_PARTS, ToolHooks.MATERIAL_REPAIR);
    public static final RecordLoadable<PartStatsModule> LOADER = RecordLoadable.create((RecordField)new OptionallyNestedLoadable<IToolPart>((Loadable<IToolPart>)TinkerLoadables.TOOL_PART_ITEM, "item").list().requiredField("parts", m -> m.parts), (RecordField)new StatScaleField("item", "parts"), (RecordField)PRIMARY_PART_FIELD, PartStatsModule::new);
    private final List<IToolPart> parts;

    @Deprecated
    public PartStatsModule(List<IToolPart> parts, float[] scales) {
        this(parts, scales, 0);
    }

    protected PartStatsModule(List<IToolPart> parts, float[] scales, int primaryPart) {
        super(parts.stream().map(IToolPart::getStatType).toList(), scales, primaryPart);
        this.parts = parts;
    }

    public RecordLoadable<PartStatsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public List<IToolPart> getParts(ToolDefinition definition) {
        return this.parts;
    }

    public static Builder parts() {
        return new Builder();
    }

    public static ArmorBuilder armor(List<ArmorSlotType> slots) {
        return new ArmorBuilder(slots);
    }

    public static class Builder {
        private final ImmutableList.Builder<IToolPart> parts = ImmutableList.builder();
        private final ImmutableList.Builder<Float> scales = ImmutableList.builder();
        private int primaryPart = 0;

        public Builder part(IToolPart part, float scale) {
            this.parts.add((Object)part);
            this.scales.add((Object)Float.valueOf(scale));
            return this;
        }

        public Builder part(Supplier<? extends IToolPart> part, float scale) {
            return this.part(part.get(), scale);
        }

        public Builder part(IToolPart part) {
            return this.part(part, 1.0f);
        }

        public Builder part(Supplier<? extends IToolPart> part) {
            return this.part(part, 1.0f);
        }

        public PartStatsModule build() {
            ImmutableList parts = this.parts.build();
            if (this.primaryPart >= parts.size() || this.primaryPart < -1) {
                throw new IllegalStateException("Primary part must be within parts list, maximum " + parts.size() + ", got " + this.primaryPart);
            }
            return new PartStatsModule((List<IToolPart>)parts, MaterialStatsModule.Builder.buildScales((List<Float>)this.scales.build()), this.primaryPart);
        }

        private Builder() {
        }

        public Builder primaryPart(int primaryPart) {
            this.primaryPart = primaryPart;
            return this;
        }
    }

    public static class ArmorBuilder
    implements ArmorSlotType.ArmorBuilder<PartStatsModule> {
        private final List<ArmorSlotType> slotTypes;
        private final Builder[] builders = new Builder[4];

        private ArmorBuilder(List<ArmorSlotType> slotTypes) {
            this.slotTypes = slotTypes;
            for (ArmorSlotType slotType : slotTypes) {
                this.builders[slotType.getIndex()] = new Builder();
            }
        }

        protected Builder getBuilder(ArmorSlotType slotType) {
            Builder builder = this.builders[slotType.getIndex()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + slotType);
            }
            return builder;
        }

        public ArmorBuilder part(ArmorSlotType slotType, IToolPart part, float scale) {
            this.getBuilder(slotType).part(part, scale);
            return this;
        }

        public ArmorBuilder part(IToolPart part, float scale) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.getBuilder(slotType).part(part, scale);
            }
            return this;
        }

        public ArmorBuilder part(Supplier<? extends IToolPart> part, float scale) {
            return this.part(part.get(), scale);
        }

        public ArmorBuilder part(EnumObject<ArmorSlotType, ? extends IToolPart> parts, float scale) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.getBuilder(slotType).part((IToolPart)parts.get((Enum)slotType), scale);
            }
            return this;
        }

        public ArmorBuilder primaryPart(int index) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.getBuilder(slotType).primaryPart(index);
            }
            return this;
        }

        @Override
        public PartStatsModule build(ArmorSlotType slot) {
            return this.getBuilder(slot).build();
        }
    }
}

