/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.build;

import java.util.List;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolStatsHook;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public record SetStatsModule(StatsNBT stats) implements ToolStatsHook,
ToolModule
{
    public static final RecordLoadable<SetStatsModule> LOADER = RecordLoadable.create((RecordField)StatsNBT.LOADABLE.requiredField("stats", SetStatsModule::stats), SetStatsModule::new);
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.TOOL_STATS);

    public RecordLoadable<SetStatsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private <T> void setStat(IToolStat<T> stat, ModifierStatsBuilder builder) {
        stat.update(builder, this.stats.get(stat));
    }

    @Override
    public void addToolStats(IToolContext context, ModifierStatsBuilder builder) {
        for (IToolStat<?> stat : this.stats.getContainedStats()) {
            this.setStat(stat, builder);
        }
    }

    public static ArmorBuilder armor(List<ArmorSlotType> slots) {
        return new ArmorBuilder(slots);
    }

    public static class ArmorBuilder
    implements ArmorSlotType.ArmorBuilder<SetStatsModule> {
        private final List<ArmorSlotType> slotTypes;
        private final StatsNBT.Builder[] builders = new StatsNBT.Builder[4];

        private ArmorBuilder(List<ArmorSlotType> slotTypes) {
            this.slotTypes = slotTypes;
            for (ArmorSlotType slotType : slotTypes) {
                this.builders[slotType.getIndex()] = StatsNBT.builder();
            }
        }

        protected StatsNBT.Builder getBuilder(ArmorSlotType slotType) {
            StatsNBT.Builder builder = this.builders[slotType.getIndex()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + slotType);
            }
            return builder;
        }

        public <T> ArmorBuilder set(ArmorSlotType slotType, IToolStat<T> stat, T value) {
            this.getBuilder(slotType).set(stat, value);
            return this;
        }

        public ArmorBuilder set(ArmorSlotType slotType, IToolStat<Float> stat, float value) {
            return this.set(slotType, (IToolStat)stat, (Object)Float.valueOf(value));
        }

        public <T> ArmorBuilder setAll(IToolStat<T> stat, T value) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.set(slotType, stat, value);
            }
            return this;
        }

        public ArmorBuilder setAll(IToolStat<Float> stat, float value) {
            return this.setAll((IToolStat)stat, (Object)Float.valueOf(value));
        }

        public final ArmorBuilder setEach(IToolStat<Float> stat, float ... values) {
            if (values.length != this.slotTypes.size()) {
                throw new IllegalStateException("Wrong number of stats set");
            }
            for (int i = 0; i < values.length; ++i) {
                this.set(this.slotTypes.get(i), stat, values[i]);
            }
            return this;
        }

        public ArmorBuilder durabilityFactor(float maxDamageFactor) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.set(slotType, ToolStats.DURABILITY, (float)ArmorSlotType.MAX_DAMAGE_ARRAY[slotType.getIndex()] * maxDamageFactor);
            }
            return this;
        }

        @Override
        public SetStatsModule build(ArmorSlotType slot) {
            return new SetStatsModule(this.getBuilder(slot).build());
        }
    }
}

