/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.aoe;

import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.module.aoe.BoxAOEIterator;
import slimeknights.tconstruct.library.tools.definition.module.aoe.IBoxExpansion;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public record CircleAOEIterator(int diameter, boolean is3D) implements AreaOfEffectIterator.Loadable
{
    public static final RecordLoadable<CircleAOEIterator> LOADER = RecordLoadable.create((RecordField)IntLoadable.FROM_ONE.defaultField("diameter", (Object)1, true, CircleAOEIterator::diameter), (RecordField)BooleanLoadable.INSTANCE.defaultField("3D", Boolean.valueOf(false), CircleAOEIterator::is3D), CircleAOEIterator::new);

    public RecordLoadable<CircleAOEIterator> getLoader() {
        return LOADER;
    }

    @Override
    public Iterable<BlockPos> getBlocks(IToolStackView tool, ItemStack stack, Player player, BlockState state, Level world, BlockPos origin, Direction sideHit, AreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel(TinkerModifiers.expanded.getId());
        return CircleAOEIterator.calculate(tool, stack, world, player, origin, sideHit, this.diameter + expanded, this.is3D, matchType);
    }

    public static Iterable<BlockPos> calculate(IToolStackView tool, ItemStack stack, Level world, Player player, BlockPos origin, Direction sideHit, int diameter, boolean is3D, AreaOfEffectIterator.AOEMatchType matchType) {
        if (diameter == 1) {
            return Collections.emptyList();
        }
        int radiusSq = diameter * diameter / 4;
        Predicate<BlockPos> posPredicate = AreaOfEffectIterator.defaultBlockPredicate(tool, stack, world, origin, matchType);
        IBoxExpansion.ExpansionDirections directions = IBoxExpansion.SIDE_HIT.getDirections(player, sideHit);
        return () -> new CircleIterator(origin, directions.width(), directions.height(), directions.traverseDown(), directions.depth(), radiusSq, diameter / 2, is3D, posPredicate);
    }

    private static class CircleIterator
    extends BoxAOEIterator.RectangleIterator {
        private final int radiusSq;

        private CircleIterator(BlockPos origin, Direction widthDir, Direction heightDir, boolean traverseDown, Direction depthDir, int radiusSq, int extra, boolean is3D, Predicate<BlockPos> posPredicate) {
            super(origin, widthDir, extra, heightDir, extra, traverseDown, depthDir, is3D ? extra : 0, posPredicate);
            this.radiusSq = radiusSq;
        }

        private int distanceSq() {
            int dx = this.origin.m_123341_() - this.mutablePos.m_123341_();
            int dy = this.origin.m_123342_() - this.mutablePos.m_123342_();
            int dz = this.origin.m_123343_() - this.mutablePos.m_123343_();
            return dx * dx + dy * dy + dz * dz;
        }

        @Override
        protected BlockPos computeNext() {
            this.mutablePos.m_122178_(this.lastX, this.lastY, this.lastZ);
            while (this.incrementPosition()) {
                if (this.mutablePos.equals((Object)this.origin) || this.distanceSq() > this.radiusSq || !this.posPredicate.test(this.mutablePos)) continue;
                this.lastX = this.mutablePos.m_123341_();
                this.lastY = this.mutablePos.m_123342_();
                this.lastZ = this.mutablePos.m_123343_();
                return this.mutablePos;
            }
            return (BlockPos)this.endOfData();
        }
    }
}

