/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.container;

import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;

public class ContainerFillingRecipe
implements ICastingRecipe,
IMultiRecipe<DisplayCastingRecipe> {
    public static final RecordLoadable<ContainerFillingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)IntLoadable.FROM_ONE.requiredField("fluid_amount", r -> r.fluidAmount), (RecordField)Loadables.ITEM.requiredField("container", r -> r.container), ContainerFillingRecipe::new);
    private final TypeAwareRecipeSerializer<?> serializer;
    private final ResourceLocation id;
    private final String group;
    private final int fluidAmount;
    private final Item container;
    private List<DisplayCastingRecipe> displayRecipes = null;

    public RecipeType<?> m_6671_() {
        return this.serializer.getType();
    }

    @Override
    public int getFluidAmount(ICastingContainer inv) {
        Fluid fluid = inv.getFluid();
        return inv.getStack().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> handler.fill(new FluidStack(fluid, this.fluidAmount), IFluidHandler.FluidAction.SIMULATE)).orElse(0);
    }

    @Override
    public boolean isConsumed() {
        return true;
    }

    @Override
    public boolean switchSlots() {
        return false;
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return 5;
    }

    public boolean matches(ICastingContainer inv, Level worldIn) {
        ItemStack stack = inv.getStack();
        Fluid fluid = inv.getFluid();
        return stack.m_41720_() == this.container.m_5456_() && stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).filter(handler -> handler.fill(new FluidStack(fluid, this.fluidAmount), IFluidHandler.FluidAction.SIMULATE) > 0).isPresent();
    }

    @Deprecated
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.container);
    }

    public ItemStack assemble(ICastingContainer inv) {
        ItemStack stack = inv.getStack().m_41777_();
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            handler.fill(new FluidStack(inv.getFluid(), this.fluidAmount, inv.getFluidTag()), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(stack);
    }

    public List<DisplayCastingRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List<ItemStack> casts = Collections.singletonList(new ItemStack((ItemLike)this.container));
            this.displayRecipes = ForgeRegistries.FLUIDS.getValues().stream().filter(fluid -> fluid.m_6859_() != Items.f_41852_ && fluid.m_7444_(fluid.m_76145_())).map(fluid -> {
                FluidStack fluidStack = new FluidStack(fluid, this.fluidAmount);
                ItemStack stack = new ItemStack((ItemLike)this.container);
                stack = FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
                    handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    return handler.getContainer();
                }).orElse(stack);
                return new DisplayCastingRecipe(this.m_6671_(), casts, Collections.singletonList(fluidStack), stack, 5, true);
            }).toList();
        }
        return this.displayRecipes;
    }

    public ContainerFillingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, int fluidAmount, Item container) {
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.fluidAmount = fluidAmount;
        this.container = container;
    }

    public TypeAwareRecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }
}

