/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.entity;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public record RestoreHungerFluidEffect(int hunger, float saturation, boolean canAlwaysEat, ItemOutput representative) implements FluidEffect<FluidEffectContext.Entity>
{
    public static final RecordLoadable<RestoreHungerFluidEffect> LOADER = RecordLoadable.create((RecordField)IntLoadable.FROM_ONE.requiredField("hunger", e -> e.hunger), (RecordField)FloatLoadable.FROM_ZERO.requiredField("saturation", e -> Float.valueOf(e.saturation)), (RecordField)BooleanLoadable.INSTANCE.defaultField("can_always_eat", Boolean.valueOf(false), e -> e.canAlwaysEat), (RecordField)ItemOutput.Loadable.OPTIONAL_ITEM.emptyField("representative_item", e -> e.representative), RestoreHungerFluidEffect::new);

    public RecordLoadable<RestoreHungerFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        Player player;
        LivingEntity target = context.getLivingTarget();
        if (target instanceof Player && (player = (Player)target).m_36391_(this.canAlwaysEat)) {
            float value = level.value();
            if (action.execute()) {
                int finalHunger = (int)((float)this.hunger * value);
                player.m_36324_().m_38707_(finalHunger, this.saturation);
                ItemStack representative = this.representative.get();
                if (!representative.m_41619_()) {
                    ModifierUtil.foodConsumer.onConsume(player, representative, finalHunger, this.saturation);
                }
            }
            return value;
        }
        return 0.0f;
    }
}

