/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionDataBuilder;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public abstract class AbstractToolDefinitionDataProvider
extends GenericDataProvider {
    private final Map<ResourceLocation, ToolDefinitionDataBuilder> allTools = new HashMap<ResourceLocation, ToolDefinitionDataBuilder>();
    private final String modId;

    public AbstractToolDefinitionDataProvider(DataGenerator generator, String modId) {
        super(generator, PackType.SERVER_DATA, "tinkering/tool_definitions");
        this.modId = modId;
    }

    protected abstract void addToolDefinitions();

    protected ToolDefinitionDataBuilder define(ResourceLocation id) {
        return this.allTools.computeIfAbsent(id, i -> ToolDefinitionDataBuilder.builder());
    }

    protected ToolDefinitionDataBuilder define(ItemLike item) {
        return this.define(Registry.f_122827_.m_7981_((Object)item.m_5456_()));
    }

    protected ToolDefinitionDataBuilder define(ToolDefinition definition) {
        return this.define(definition.getId());
    }

    protected ArmorDataBuilder defineArmor(ModifiableArmorMaterial armorMaterial) {
        return new ArmorDataBuilder(armorMaterial);
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        this.addToolDefinitions();
        Map relevantDefinitions = ToolDefinitionLoader.getInstance().getRegisteredToolDefinitions().stream().filter(def -> def.getId().m_135827_().equals(this.modId)).collect(Collectors.toMap(ToolDefinition::getId, Function.identity()));
        for (ToolDefinition toolDefinition : relevantDefinitions.values()) {
            ResourceLocation name = toolDefinition.getId();
            if (this.allTools.containsKey(name)) continue;
            throw new IllegalStateException(String.format("Missing tool definition for '%s'", name));
        }
        for (Map.Entry entry : this.allTools.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            ToolDefinition definition = (ToolDefinition)relevantDefinitions.get(id);
            if (definition == null) {
                throw new IllegalStateException("Unknown tool definition with ID " + id);
            }
            this.saveJson(cache, id, ToolDefinitionData.LOADABLE.serialize((Object)((ToolDefinitionDataBuilder)entry.getValue()).build()));
        }
    }

    protected class ArmorDataBuilder {
        private final ResourceLocation name;
        private final ToolDefinitionDataBuilder[] builders;
        private final List<ArmorSlotType> slotTypes;

        private ArmorDataBuilder(ModifiableArmorMaterial armorMaterial) {
            this.name = armorMaterial.getId();
            this.builders = new ToolDefinitionDataBuilder[4];
            ImmutableList.Builder slotTypes = ImmutableList.builder();
            for (ArmorSlotType slotType : ArmorSlotType.values()) {
                ToolDefinition definition = armorMaterial.getArmorDefinition(slotType);
                if (definition == null) continue;
                this.builders[slotType.getIndex()] = AbstractToolDefinitionDataProvider.this.define(definition);
                slotTypes.add((Object)slotType);
            }
            this.slotTypes = slotTypes.build();
        }

        protected ToolDefinitionDataBuilder getBuilder(ArmorSlotType slotType) {
            ToolDefinitionDataBuilder builder = this.builders[slotType.getIndex()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + slotType + " for material " + this.name);
            }
            return builder;
        }

        @SafeVarargs
        public final <T extends ToolModule> ArmorDataBuilder module(ArmorSlotType slotType, T module, ModuleHook<? super T> ... hooks) {
            this.getBuilder(slotType).module(module, hooks);
            return this;
        }

        public ArmorDataBuilder module(ArmorSlotType slotType, ToolModule module) {
            this.getBuilder(slotType).module(module);
            return this;
        }

        public ArmorDataBuilder module(ArmorSlotType slotType, ToolModule ... modules) {
            this.getBuilder(slotType).module(modules);
            return this;
        }

        @SafeVarargs
        public final <T extends ToolModule> ArmorDataBuilder module(T module, ModuleHook<? super T> ... hooks) {
            for (ArmorSlotType armorSlot : this.slotTypes) {
                this.module(armorSlot, module, hooks);
            }
            return this;
        }

        public ArmorDataBuilder module(ToolModule module) {
            for (ArmorSlotType armorSlot : this.slotTypes) {
                this.module(armorSlot, module);
            }
            return this;
        }

        public ArmorDataBuilder module(ToolModule ... modules) {
            for (ArmorSlotType armorSlot : this.slotTypes) {
                this.module(armorSlot, modules);
            }
            return this;
        }

        @SafeVarargs
        public final <T extends ToolModule> ArmorDataBuilder module(ArmorSlotType.ArmorBuilder<T> builder, ModuleHook<? super T> ... hooks) {
            for (ArmorSlotType armorSlot : this.slotTypes) {
                this.module(armorSlot, (ToolModule)builder.build(armorSlot), hooks);
            }
            return this;
        }

        public ArmorDataBuilder module(ArmorSlotType.ArmorBuilder<? extends ToolModule> builder) {
            for (ArmorSlotType armorSlot : this.slotTypes) {
                this.module(armorSlot, builder.build(armorSlot));
            }
            return this;
        }

        @SafeVarargs
        public final <T extends ToolModule> ArmorDataBuilder modules(Function<List<ArmorSlotType>, ArmorSlotType.ArmorBuilder<T>> constructor, ModuleHook<? super T> ... hooks) {
            return this.module(constructor.apply(this.slotTypes), hooks);
        }

        public ArmorDataBuilder modules(Function<List<ArmorSlotType>, ArmorSlotType.ArmorBuilder<? extends ToolModule>> constructor) {
            return this.module(constructor.apply(this.slotTypes));
        }
    }
}

