/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.common.hash.Hashing;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;

public abstract class GenericNBTProvider
implements DataProvider {
    protected final DataGenerator generator;
    protected final PackType packType;
    protected final String folder;

    public ResourceLocation localize(ResourceLocation name) {
        return JsonHelper.localize((ResourceLocation)name, (String)this.folder, (String)".nbt");
    }

    protected void saveNBT(CachedOutput cache, ResourceLocation location, CompoundTag data) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            NbtIo.m_128947_((CompoundTag)data, (OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            Path outputPath = this.generator.m_123916_().resolve(Paths.get(this.packType.m_10305_(), location.m_135827_(), this.folder, location.m_135815_() + ".nbt"));
            cache.m_213871_(outputPath, bytes, Hashing.sha1().hashBytes(bytes));
        }
        catch (IOException e) {
            TConstruct.LOG.error("Couldn't write NBT for {}", (Object)location, (Object)e);
        }
    }

    public GenericNBTProvider(DataGenerator generator, PackType packType, String folder) {
        this.generator = generator;
        this.packType = packType;
        this.folder = folder;
    }
}

