/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.mapping.CompactLoadable;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.ReversedListBuilder;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.BakedUniqueGuiModel;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.worktable.ModifierSetWorktableRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolModel
implements IUnbakedGeometry<ToolModel> {
    public static final IGeometryLoader<ToolModel> LOADER = ToolModel::deserialize;
    private static final BitSet SMALL_TOOL_TYPES = new BitSet();
    public static final ItemColor COLOR_HANDLER = (stack, index) -> {
        ItemOverrides patt4985$temp;
        BakedModel itemModel;
        if (index >= 0 && (itemModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(stack.m_41720_())) != null && (patt4985$temp = itemModel.m_7343_()) instanceof MaterialOverrideHandler) {
            ModifierEntry entry;
            int i;
            MaterialOverrideHandler overrides = (MaterialOverrideHandler)patt4985$temp;
            ToolStack tool = ToolStack.from(stack);
            int localIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            ModifierEntry[] firsts = new ModifierEntry[overrides.firstModifiers.size()];
            for (i = modifiers.size() - 1; i >= 0; --i) {
                entry = modifiers.get(i);
                ModifierId id = entry.getId();
                int firstIndex = FirstModifier.indexOf(overrides.firstModifiers, id);
                if (firstIndex != -1) {
                    firsts[firstIndex] = entry;
                    continue;
                }
                IBakedModifierModel modifierModel = overrides.modifierModels.get((Object)entry.getId());
                if (modifierModel == null) continue;
                int modelIndexes = modifierModel.getTintIndexes();
                if (localIndex + modelIndexes > index) {
                    return modifierModel.getTint(tool, entry, index - localIndex);
                }
                localIndex += modelIndexes;
            }
            for (i = firsts.length - 1; i >= 0; --i) {
                IBakedModifierModel model;
                entry = firsts[i];
                FirstModifier first = overrides.firstModifiers.get(i);
                if (entry == null && !first.forced || (model = overrides.modifierModels.get((Object)first.id)) == null) continue;
                int modelIndexes = model.getTintIndexes();
                if (localIndex + modelIndexes > index) {
                    return model.getTint(tool, Objects.requireNonNullElse(entry, ModifierEntry.EMPTY), index - localIndex);
                }
                localIndex += modelIndexes;
            }
        }
        return -1;
    };
    private List<ToolPart> toolParts;
    private final boolean isLarge;
    private final Vec2 offset;
    private final List<ResourceLocation> smallModifierRoots;
    private final List<ResourceLocation> largeModifierRoots;
    private final List<FirstModifier> firstModifiers;
    private Map<ModifierId, IBakedModifierModel> modifierModels = Collections.emptyMap();

    public static synchronized ItemTransforms.TransformType registerSmallTool(ItemTransforms.TransformType type) {
        SMALL_TOOL_TYPES.set(type.ordinal());
        return type;
    }

    public static void registerItemColors(ItemColors colors, Supplier<? extends IModifiable> item) {
        colors.m_92689_(COLOR_HANDLER, new ItemLike[]{item.get()});
    }

    public static ToolModel deserialize(JsonObject json, JsonDeserializationContext context) {
        List parts = Collections.emptyList();
        if (json.has("parts")) {
            parts = JsonHelper.parseList((JsonObject)json, (String)"parts", ToolPart::read);
        }
        boolean isLarge = GsonHelper.m_13855_((JsonObject)json, (String)"large", (boolean)false);
        Vec2 offset = Vec2.f_82462_;
        if (json.has("large_offset")) {
            offset = MaterialModel.getVec2(json, "large_offset");
        }
        List smallModifierRoots = Collections.emptyList();
        List largeModifierRoots = Collections.emptyList();
        if (json.has("modifier_roots")) {
            if (isLarge) {
                JsonObject modifierRoots = GsonHelper.m_13930_((JsonObject)json, (String)"modifier_roots");
                BiFunction<JsonElement, String, ResourceLocation> parser = (element, string) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)string));
                smallModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"small", parser);
                largeModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"large", parser);
            } else {
                smallModifierRoots = JsonHelper.parseList((JsonObject)json, (String)"modifier_roots", (element, string) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)string)));
            }
        }
        List firstModifiers = (List)FirstModifier.LOADABLE.getOrDefault(json, "first_modifiers", List.of());
        return new ToolModel(parts, isLarge, offset, smallModifierRoots, largeModifierRoots, firstModifiers);
    }

    public ToolModel(List<ToolPart> parts, boolean isLarge, Vec2 offset, List<ResourceLocation> smallModifierRoots, List<ResourceLocation> largeModifierRoots, List<FirstModifier> firstModifiers) {
        this.toolParts = parts;
        this.isLarge = isLarge;
        this.offset = offset;
        this.smallModifierRoots = smallModifierRoots;
        this.largeModifierRoots = largeModifierRoots;
        this.firstModifiers = firstModifiers;
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet allTextures = Sets.newHashSet();
        if (this.toolParts.isEmpty()) {
            this.toolParts = ToolPart.DEFAULT_PARTS;
        }
        for (ToolPart part : this.toolParts) {
            if (part.hasMaterials()) {
                MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false), null);
                if (!this.isLarge) continue;
                MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true), null);
                continue;
            }
            allTextures.add(owner.getMaterial(part.getName(false)));
            if (!this.isLarge) continue;
            allTextures.add(owner.getMaterial(part.getName(true)));
        }
        this.modifierModels = ModifierModelManager.getModelsForTool(this.smallModifierRoots, this.isLarge ? this.largeModifierRoots : Collections.emptyList(), allTextures);
        return allTextures;
    }

    private static void addModifierQuads(Function<Material, TextureAtlasSprite> spriteGetter, Map<ModifierId, IBakedModifierModel> modifierModels, List<FirstModifier> firstModifiers, IToolStackView tool, Consumer<Collection<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels, Transformation transforms, boolean isLarge) {
        if (!modifierModels.isEmpty()) {
            int modelIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            ModifierEntry[] firsts = new ModifierEntry[firstModifiers.size()];
            if (!modifiers.isEmpty()) {
                Set<ModifierId> hidden = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), TConstruct.getResource("invisible_modifiers"));
                for (int i = modifiers.size() - 1; i >= 0; --i) {
                    IBakedModifierModel model;
                    ModifierEntry entry = modifiers.get(i);
                    ModifierId modifier = entry.getModifier().getId();
                    int index = FirstModifier.indexOf(firstModifiers, modifier);
                    if (index != -1) {
                        firsts[index] = entry;
                        continue;
                    }
                    if (hidden.contains((Object)modifier) || (model = modifierModels.get((Object)modifier)) == null) continue;
                    model.addQuads(tool, entry, spriteGetter, transforms, isLarge, modelIndex, quadConsumer, pixels);
                    modelIndex += model.getTintIndexes();
                }
            }
            for (int i = firsts.length - 1; i >= 0; --i) {
                IBakedModifierModel model;
                ModifierEntry entry = firsts[i];
                FirstModifier first = firstModifiers.get(i);
                if (entry == null && !first.forced || (model = modifierModels.get((Object)first.id)) == null) continue;
                model.addQuads(tool, Objects.requireNonNullElse(entry, ModifierEntry.EMPTY), spriteGetter, transforms, isLarge, modelIndex, quadConsumer, pixels);
                modelIndex += model.getTintIndexes();
            }
        }
    }

    private static IModelBuilder<?> makeModelBuilder(IGeometryBakingContext context, ItemOverrides overrides, TextureAtlasSprite particle) {
        return IModelBuilder.of((boolean)context.useAmbientOcclusion(), (boolean)context.useBlockLight(), (boolean)context.isGui3d(), (ItemTransforms)context.getTransforms(), (ItemOverrides)overrides, (TextureAtlasSprite)particle, (RenderTypeGroup)MantleItemLayerModel.getDefaultRenderType((IGeometryBakingContext)context));
    }

    private static BakedModel bakeInternal(IGeometryBakingContext owner, Function<Material, TextureAtlasSprite> spriteGetter, @Nullable Transformation largeTransforms, List<ToolPart> parts, Map<ModifierId, IBakedModifierModel> modifierModels, List<FirstModifier> firstModifiers, List<MaterialVariantId> materials, @Nullable IToolStackView tool, ItemOverrides overrides) {
        ItemLayerPixels largePixels;
        Transformation smallTransforms = Transformation.m_121093_();
        ReversedListBuilder smallQuads = new ReversedListBuilder();
        ItemLayerPixels smallPixels = new ItemLayerPixels();
        ReversedListBuilder largeQuads = largeTransforms != null ? new ReversedListBuilder() : smallQuads;
        ItemLayerPixels itemLayerPixels = largePixels = largeTransforms != null ? new ItemLayerPixels() : smallPixels;
        if (tool != null && !modifierModels.isEmpty()) {
            ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, arg_0 -> ((ReversedListBuilder)smallQuads).add(arg_0), smallPixels, smallTransforms, false);
            if (largeTransforms != null) {
                ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, arg_0 -> ((ReversedListBuilder)largeQuads).add(arg_0), largePixels, largeTransforms, true);
            }
        }
        TextureAtlasSprite particle = null;
        for (int i = parts.size() - 1; i >= 0; --i) {
            ToolPart part = parts.get(i);
            if (part.hasMaterials()) {
                int index = part.index();
                MaterialId material = index < materials.size() ? materials.get(index) : IMaterial.UNKNOWN_ID;
                MaterialRenderInfo.TintedSprite materialSprite = MaterialModel.getMaterialSprite(spriteGetter, owner.getMaterial(part.getName(false)), material);
                particle = materialSprite.sprite();
                smallQuads.add((Object)MantleItemLayerModel.getQuadsForSprite((int)materialSprite.color(), (int)-1, (TextureAtlasSprite)materialSprite.sprite(), (Transformation)smallTransforms, (int)materialSprite.emissivity(), (ItemLayerPixels)smallPixels));
                if (largeTransforms == null) continue;
                largeQuads.add(MaterialModel.getQuadsForMaterial(spriteGetter, owner.getMaterial(part.getName(true)), material, -1, largeTransforms, largePixels));
                continue;
            }
            particle = spriteGetter.apply(owner.getMaterial(part.getName(false)));
            smallQuads.add((Object)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)particle, (Transformation)smallTransforms, (int)0, (ItemLayerPixels)smallPixels));
            if (largeTransforms == null) continue;
            largeQuads.add((Object)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)spriteGetter.apply(owner.getMaterial(part.getName(true))), (Transformation)largeTransforms, (int)0, (ItemLayerPixels)largePixels));
        }
        if (particle == null) {
            particle = spriteGetter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_()));
            TConstruct.LOG.error("Created tool model without a particle sprite, this means it somehow has no parts. This should not be possible");
        }
        IModelBuilder<?> smallModelBuilder = ToolModel.makeModelBuilder(owner, overrides, particle);
        IModelBuilder<?> guiModelBuilder = ToolModel.makeModelBuilder(owner, overrides, particle);
        smallQuads.build(quads -> quads.forEach(quad -> {
            smallModelBuilder.addUnculledFace(quad);
            if (quad.m_111306_() == Direction.SOUTH) {
                guiModelBuilder.addUnculledFace(quad);
            }
        }));
        if (largeTransforms == null) {
            return new BakedUniqueGuiModel(smallModelBuilder.build(), guiModelBuilder.build());
        }
        IModelBuilder<?> largeModelBuilder = ToolModel.makeModelBuilder(owner, overrides, particle);
        largeQuads.build(quads -> quads.forEach(arg_0 -> ((IModelBuilder)largeModelBuilder).addUnculledFace(arg_0)));
        return new BakedLargeToolModel(largeModelBuilder.build(), smallModelBuilder.build(), guiModelBuilder.build());
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        Transformation largeTransforms = this.isLarge ? new Transformation(new Vector3f((this.offset.f_82470_ - 8.0f) / 32.0f, (-this.offset.f_82471_ - 8.0f) / 32.0f, 0.0f), null, new Vector3f(2.0f, 2.0f, 1.0f), null) : null;
        overrides = new MaterialOverrideHandler(owner, this.toolParts, this.firstModifiers, largeTransforms, this.modifierModels, overrides);
        return ToolModel.bakeInternal(owner, spriteGetter, largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, Collections.emptyList(), null, overrides);
    }

    private record FirstModifier(ModifierId id, boolean forced) {
        private static final Loadable<List<FirstModifier>> LOADABLE = CompactLoadable.of((RecordLoadable)RecordLoadable.create((RecordField)ModifierId.PARSER.requiredField("name", FirstModifier::id), (RecordField)BooleanLoadable.INSTANCE.defaultField("forced", (Object)false, false, FirstModifier::forced), FirstModifier::new), (Loadable)ModifierId.PARSER.flatXmap(id -> new FirstModifier((ModifierId)((Object)id), false), FirstModifier::id), f -> !f.forced).list(0);

        public static int indexOf(List<FirstModifier> list, ModifierId id) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get((int)i).id.equals((Object)id)) continue;
                return i;
            }
            return -1;
        }
    }

    private record ToolPart(String name, int index) {
        public static final ToolPart DEFAULT = new ToolPart("tool", -1);
        public static final List<ToolPart> DEFAULT_PARTS = List.of(DEFAULT);

        public boolean hasMaterials() {
            return this.index >= 0;
        }

        public String getName(boolean isLarge) {
            if (isLarge) {
                return "large_" + this.name;
            }
            return this.name;
        }

        public static ToolPart read(JsonObject json) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            int index = GsonHelper.m_13824_((JsonObject)json, (String)"index", (int)-1);
            return new ToolPart(name, index);
        }
    }

    private static class BakedLargeToolModel
    extends BakedModelWrapper<BakedModel> {
        private final BakedModel small;
        private final BakedModel gui;

        public BakedLargeToolModel(BakedModel large, BakedModel small, BakedModel gui) {
            super(large);
            this.small = small;
            this.gui = gui;
        }

        public BakedModel applyTransform(ItemTransforms.TransformType cameraTransformType, PoseStack mat, boolean applyLeftHandTransform) {
            BakedModel model = this.originalModel;
            if (cameraTransformType == ItemTransforms.TransformType.GUI) {
                model = this.gui;
            } else if (SMALL_TOOL_TYPES.get(cameraTransformType.ordinal())) {
                model = this.small;
            }
            return model.applyTransform(cameraTransformType, mat, applyLeftHandTransform);
        }
    }

    public static final class MaterialOverrideHandler
    extends ItemOverrides {
        private static boolean ignoreNested = false;
        private final Cache<ToolCacheKey, BakedModel> cache = CacheBuilder.newBuilder().maximumSize((long)MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().size() * 3L / 2L).build();
        private final IGeometryBakingContext owner;
        private final List<ToolPart> toolParts;
        private final List<FirstModifier> firstModifiers;
        @Nullable
        private final Transformation largeTransforms;
        private final Map<ModifierId, IBakedModifierModel> modifierModels;
        private final ItemOverrides nested;

        private MaterialOverrideHandler(IGeometryBakingContext owner, List<ToolPart> toolParts, List<FirstModifier> firstModifiers, @Nullable Transformation largeTransforms, Map<ModifierId, IBakedModifierModel> modifierModels, ItemOverrides nested) {
            this.owner = owner;
            this.toolParts = toolParts;
            this.firstModifiers = firstModifiers;
            this.largeTransforms = largeTransforms;
            this.modifierModels = modifierModels;
            this.nested = nested;
        }

        private BakedModel bakeDynamic(List<MaterialVariantId> materials, IToolStackView tool) {
            return ToolModel.bakeInternal(this.owner, Material::m_119204_, this.largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, materials, tool, ItemOverrides.f_111734_);
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            ToolStack tool;
            List<MaterialVariantId> materialIds;
            block8: {
                BakedModel overridden;
                if (!ignoreNested && (overridden = this.nested.m_173464_(originalModel, stack, world, entity, seed)) != null && overridden != originalModel) {
                    ignoreNested = true;
                    BakedModel finalModel = overridden.m_7343_().m_173464_(overridden, stack, world, entity, seed);
                    ignoreNested = false;
                    return finalModel;
                }
                materialIds = MaterialIdNBT.from(stack).getMaterials();
                tool = ToolStack.from(stack);
                if (materialIds.isEmpty() && tool.getUpgrades().isEmpty()) {
                    for (FirstModifier modifier : this.firstModifiers) {
                        if (!modifier.forced) continue;
                        break block8;
                    }
                    return originalModel;
                }
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            Set<ModifierId> hidden = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), TConstruct.getResource("invisible_modifiers"));
            ModifierEntry[] firstEntries = new ModifierEntry[this.firstModifiers.size()];
            for (ModifierEntry entry : tool.getUpgrades().getModifiers()) {
                Object cacheKey;
                IBakedModifierModel model;
                ModifierId id = entry.getId();
                int index = FirstModifier.indexOf(this.firstModifiers, id);
                if (index != -1) {
                    firstEntries[index] = entry;
                    continue;
                }
                if (hidden.contains((Object)id) || (model = this.modifierModels.get((Object)id)) == null || (cacheKey = model.getCacheKey(tool, entry)) == null) continue;
                builder.add(cacheKey);
            }
            for (int i = 0; i < this.firstModifiers.size(); ++i) {
                Object cacheKey;
                IBakedModifierModel model;
                FirstModifier modifier = this.firstModifiers.get(i);
                ModifierEntry entry = firstEntries[i];
                if (entry == null && !modifier.forced || (model = this.modifierModels.get((Object)modifier.id)) == null || (cacheKey = model.getCacheKey(tool, Objects.requireNonNullElse(entry, ModifierEntry.EMPTY))) == null) continue;
                builder.add(cacheKey);
            }
            try {
                return (BakedModel)this.cache.get((Object)new ToolCacheKey(materialIds, (List<Object>)builder.build()), () -> this.bakeDynamic(materialIds, tool));
            }
            catch (ExecutionException e) {
                TConstruct.LOG.error("Failed to get tool model from cache", (Throwable)e);
                return originalModel;
            }
        }
    }

    private record ToolCacheKey(List<MaterialVariantId> materials, List<Object> modifierData) {
    }
}

