/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class MaterialRenderInfo {
    private final MaterialVariantId identifier;
    @Nullable
    private final ResourceLocation texture;
    private final String[] fallbacks;
    private final int vertexColor;
    private final int luminosity;

    @Nullable
    private TextureAtlasSprite trySprite(Material base, String suffix, Function<Material, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite sprite = spriteGetter.apply(MaterialRenderInfo.getMaterial(base.m_119203_(), suffix));
        if (!MissingTextureAtlasSprite.m_118071_().equals((Object)sprite.m_118413_())) {
            return sprite;
        }
        return null;
    }

    public TintedSprite getSprite(Material base, Function<Material, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite sprite;
        if (this.texture != null && (sprite = this.trySprite(base, MaterialRenderInfo.getSuffix(this.texture), spriteGetter)) != null) {
            return new TintedSprite(sprite, -1, this.getLuminosity());
        }
        for (String fallback : this.fallbacks) {
            sprite = this.trySprite(base, fallback, spriteGetter);
            if (sprite == null) continue;
            return new TintedSprite(sprite, this.vertexColor, this.getLuminosity());
        }
        return new TintedSprite(spriteGetter.apply(base), this.vertexColor, this.getLuminosity());
    }

    public void getTextureDependencies(Predicate<Material> textures, Material base) {
        if (this.texture != null && textures.test(MaterialRenderInfo.getMaterial(base.m_119203_(), MaterialRenderInfo.getSuffix(this.texture)))) {
            return;
        }
        for (String fallback : this.fallbacks) {
            if (textures.test(MaterialRenderInfo.getMaterial(base.m_119203_(), fallback))) break;
        }
    }

    public static String getSuffix(ResourceLocation material) {
        if ("minecraft".equals(material.m_135827_())) {
            return material.m_135815_();
        }
        return material.m_135827_() + "_" + material.m_135815_();
    }

    private static Material getMaterial(ResourceLocation texture, String suffix) {
        return new Material(InventoryMenu.f_39692_, new ResourceLocation(texture.m_135827_(), texture.m_135815_() + "_" + suffix));
    }

    public MaterialRenderInfo(MaterialVariantId identifier, @Nullable ResourceLocation texture, String[] fallbacks, int vertexColor, int luminosity) {
        this.identifier = identifier;
        this.texture = texture;
        this.fallbacks = fallbacks;
        this.vertexColor = vertexColor;
        this.luminosity = luminosity;
    }

    public MaterialVariantId getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public String[] getFallbacks() {
        return this.fallbacks;
    }

    public int getVertexColor() {
        return this.vertexColor;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public record TintedSprite(TextureAtlasSprite sprite, int color, int emissivity) {
    }
}

