/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.library.client.armor.ArmorModelManager;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;

public abstract class AbstractArmorModelProvider
extends GenericDataProvider {
    private final Map<ResourceLocation, ArmorModelManager.ArmorModel> models = new HashMap<ResourceLocation, ArmorModelManager.ArmorModel>();

    public AbstractArmorModelProvider(DataGenerator generator) {
        super(generator, PackType.CLIENT_RESOURCES, "tinkering/armor_models");
    }

    protected abstract void addModels();

    public void m_213708_(CachedOutput output) throws IOException {
        this.addModels();
        this.models.forEach((id, model) -> this.saveJson(output, (ResourceLocation)id, ArmorModelManager.ArmorModel.LOADABLE.serialize(model)));
    }

    protected void addModel(ResourceLocation name, ArmorTextureSupplier ... layers) {
        ArmorModelManager.ArmorModel existing = this.models.putIfAbsent(name, new ArmorModelManager.ArmorModel(List.of(layers)));
        if (existing != null) {
            throw new IllegalArgumentException("Duplicate armor model at " + name + ", previous value " + existing);
        }
    }

    protected void addModel(IdAwareObject name, ArmorTextureSupplier ... layers) {
        this.addModel(name.getId(), layers);
    }

    protected void addModel(IdAwareObject name, Function<ResourceLocation, ArmorTextureSupplier[]> layers) {
        this.addModel(name.getId(), layers.apply(name.getId()));
    }
}

