/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.core.registry.RegistryManager;

public abstract class ValhelsiaBlockStateProvider
extends BlockStateProvider {
    private final Set<RegistryObject<Block>> remainingBlocks;

    public ValhelsiaBlockStateProvider(DataGenerator gen, RegistryManager registryManager, ExistingFileHelper exFileHelper) {
        super(gen, registryManager.modId(), exFileHelper);
        this.remainingBlocks = new HashSet(registryManager.getBlockHelper().getRegistryObjects());
    }

    public Set<RegistryObject<Block>> getRemainingBlocks() {
        return this.remainingBlocks;
    }

    public void forEach(Predicate<Block> predicate, Consumer<Block> consumer) {
        Iterator<RegistryObject<Block>> iterator = this.getRemainingBlocks().iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next().get();
            if (!predicate.test(block)) continue;
            consumer.accept(block);
            iterator.remove();
        }
    }

    public void forEach(Consumer<Block> consumer) {
        Iterator<RegistryObject<Block>> iterator = this.getRemainingBlocks().iterator();
        while (iterator.hasNext()) {
            consumer.accept((Block)iterator.next().get());
            iterator.remove();
        }
    }

    @SafeVarargs
    public final <T extends Block> void take(Consumer<T> consumer, RegistryObject<? extends Block> ... blocks) {
        for (RegistryObject<? extends Block> block : blocks) {
            consumer.accept((Block)block.get());
            this.getRemainingBlocks().remove(block);
        }
    }

    public String getName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ModelFile.ExistingModelFile getExistingModel(ResourceLocation resourceLocation) {
        return this.models().getExistingFile(resourceLocation);
    }

    public void withExistingModel(Block block) {
        this.withExistingModel(block, false);
    }

    public void withExistingModel(Block block, boolean mcLoc) {
        this.simpleBlock(block, (ModelFile)this.getExistingModel(mcLoc ? this.mcLoc("block/" + this.getName(block)) : this.modLoc("block/" + this.getName(block))));
    }

    public void pressurePlateBlock(Block block, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.mcLoc("block/pressure_plate_up"))).texture("texture", texture);
        ModelBuilder modelDown = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_down", this.mcLoc("block/pressure_plate_down"))).texture("texture", texture);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelDown).addModel();
    }

    public void buttonBlock(ButtonBlock block, ResourceLocation texture) {
        super.buttonBlock(block, texture);
        ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_inventory", this.mcLoc("block/button_inventory"))).texture("texture", texture);
    }

    public void fenceBlock(FenceBlock block, ResourceLocation texture) {
        super.fenceBlock(block, texture);
        this.models().fenceInventory(this.getName((Block)block) + "_inventory", texture);
    }

    public void wallBlock(WallBlock block, ResourceLocation texture) {
        super.wallBlock(block, texture);
        this.models().wallInventory(this.getName((Block)block) + "_inventory", texture);
    }

    public void layerBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int height = (Integer)state.m_61143_((Property)BlockStateProperties.f_61417_) * 2;
            ModelFile model = height == 16 ? this.cubeAll(block) : ((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_" + height, this.mcLoc("block/snow_height" + height))).texture("texture", this.modLoc("block/" + this.getName(block)));
            return ConfiguredModel.builder().modelFile(model).build();
        });
    }

    public void simpleFlowerPotBlock(Block block, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.mcLoc("block/flower_pot_cross"))).texture("plant", texture);
        this.simpleBlock(block, (ModelFile)model);
    }
}

