/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.cosmetics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.client.loading.ClientModLoader;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticType;
import net.valhelsia.valhelsia_core.client.cosmetics.source.CosmeticsSource;

public class CosmeticsRegistry {
    private static final Map<String, CosmeticsSource> COSMETICS_SOURCES = new Object2ObjectArrayMap();

    public static void addSource(CosmeticsSource source) {
        Preconditions.checkArgument((boolean)ClientModLoader.isLoading(), (Object)"Cosmetic Sources can only be registered during client loading!");
        if (COSMETICS_SOURCES.putIfAbsent(source.getName(), source) != null) {
            throw new IllegalArgumentException("Duplicate cosmetics source registration:" + source.getName());
        }
    }

    public static void registerType(CosmeticsSource source, CosmeticType.Builder type) {
        Preconditions.checkArgument((boolean)ClientModLoader.isLoading(), (Object)"Cosmetic Types can only be registered during client loading!");
        source.addType(type.build());
    }

    protected static List<CosmeticsSource> getSources() {
        return ImmutableList.copyOf(COSMETICS_SOURCES.values());
    }

    public static Optional<CosmeticsSource> getSource(String name) {
        return Optional.ofNullable(COSMETICS_SOURCES.get(name));
    }
}

