/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;

public class Stats {
    protected final ChatFormatting textColor;
    protected final ChatFormatting valueColor;
    protected final List<String> groups = new ArrayList<String>();
    protected String group = "";

    protected Stats(ChatFormatting textColor, ChatFormatting valueColor) {
        this.textColor = textColor;
        this.valueColor = valueColor;
    }

    public static Stats of(ChatFormatting textColor, ChatFormatting valueColor) {
        return new Stats(textColor, valueColor);
    }

    protected void endGroup() {
        this.group = this.group + ")";
        this.groups.add(this.group);
        this.group = "";
    }

    public Stats group(String name) {
        if (!this.group.isEmpty()) {
            this.endGroup();
        }
        this.group = this.textColor + name + " (";
        return this;
    }

    public Stats value(String name, int value) {
        if (!this.group.endsWith("(")) {
            this.group = this.group + ", ";
        }
        this.group = this.group + this.textColor + name + ": " + this.valueColor + value + this.textColor;
        return this;
    }

    public List<String> toList() {
        if (!this.group.isEmpty()) {
            this.endGroup();
        }
        return Collections.unmodifiableList(this.groups);
    }
}

