/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.proxy.messages.PlayerEntityTagMessage;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkDirection;

public class StructureHouse
extends Structure {
    private BlockPos chestPosition = null;
    private ArrayList<BlockPos> furnacePositions = new ArrayList();
    private BlockPos trapDoorPosition = null;

    public static void ScanModernHouseStructure(Level world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(11);
        clearedSpace.getShape().setLength(18);
        clearedSpace.getShape().setWidth(14);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(4);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BlockPos corner = originalPos.m_122030_(4).m_122019_().m_7495_();
        BlockPos corner2 = originalPos.m_122025_(9).m_122020_(19).m_6630_(11);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\modern_starting_house.zip", clearedSpace, playerFacing, false, false);
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Block foundBlock, BlockState blockState, Player player) {
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        if (!houseConfig.addBed && foundBlock instanceof BedBlock || !houseConfig.addChest && foundBlock instanceof ChestBlock || !houseConfig.addTorches && foundBlock instanceof TorchBlock || !houseConfig.addCraftingTable && foundBlock instanceof CraftingTableBlock || !houseConfig.addFurnace && foundBlock instanceof FurnaceBlock || !houseConfig.addChest && foundBlock instanceof BarrelBlock || foundBlock instanceof SeagrassBlock || foundBlock instanceof TallSeagrassBlock) {
            return true;
        }
        if (foundBlock instanceof FurnaceBlock) {
            this.furnacePositions.add(block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing));
        } else if (foundBlock instanceof TrapDoorBlock && houseConfig.addMineShaft && this.trapDoorPosition == null) {
            this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof ChestBlock && this.chestPosition == null || foundBlock instanceof BarrelBlock && this.chestPosition == null) {
            this.chestPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock == Blocks.f_50056_ && houseConfig.addMineShaft) {
            this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing).m_7494_();
        } else if (foundBlock instanceof BedBlock && houseConfig.addBed) {
            BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            Tuple<BlockState, BlockState> blockStateTuple = BuildingMethods.getBedState(bedHeadPosition, bedFootPosition, houseConfig.bedColor);
            block.setBlockState(blockStateTuple.getFirst());
            block.getSubBlock().setBlockState(blockStateTuple.getSecond());
            this.priorityOneBlocks.add(block);
            return true;
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Player player) {
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData(player);
        BuildingMethods.FillFurnaces((Level)world, this.furnacePositions);
        if (this.chestPosition != null && houseConfig.addChestContents) {
            BuildingMethods.FillChest((Level)world, this.chestPosition);
        }
        int minimumHeightForMineshaft = world.m_141937_() + 21;
        if (this.trapDoorPosition != null && this.trapDoorPosition.m_123342_() > minimumHeightForMineshaft && houseConfig.addMineShaft) {
            BuildingMethods.PlaceMineShaft(world, this.trapDoorPosition.m_7495_(), houseConfig.houseFacing, false);
        }
        playerConfig.builtStarterHouse = true;
        playerConfig.saveToPlayer(player);
        Prefab.network.sendTo((Object)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag(player)), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    protected boolean hasGlassColor(StructureConfiguration configuration) {
        return true;
    }

    @Override
    protected FullDyeColor getGlassColor(StructureConfiguration configuration) {
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        return houseConfig.glassColor;
    }
}

