/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.config.enums.FarmAdvancedOptions;
import com.wuest.prefab.structures.config.enums.FarmImprovedOptions;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class StructureBasic
extends Structure {
    private BlockPos customBlockPos = null;
    private ArrayList<BlockPos> mobSpawnerPos = new ArrayList();

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Block foundBlock, BlockState blockState, Player player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        String structureName = config.basicStructureName.getName();
        BaseOption chosenOption = config.chosenOption;
        if (foundBlock instanceof HopperBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.FarmImproved.getName()) && chosenOption == FarmImprovedOptions.AutomatedChickenCoop) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof TrapDoorBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else {
            if (foundBlock instanceof BedBlock && chosenOption.getHasBedColor()) {
                BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                Tuple<BlockState, BlockState> blockStateTuple = BuildingMethods.getBedState(bedHeadPosition, bedFootPosition, config.bedColor);
                block.setBlockState(blockStateTuple.getFirst());
                block.getSubBlock().setBlockState(blockStateTuple.getSecond());
                this.priorityOneBlocks.add(block);
                return true;
            }
            if (foundBlock instanceof SpawnerBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.FarmAdvanced.getName()) && chosenOption == FarmAdvancedOptions.MonsterMasher && CommonProxy.proxyConfiguration.serverConfiguration.includeSpawnersInMasher) {
                this.mobSpawnerPos.add(block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing));
            }
        }
        return false;
    }

    @Override
    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, Level world, BlockPos originalPos, BlockPos blockPos) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName()) || config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBaseImproved.getName())) {
            BlockState blockState = world.m_8055_(blockPos);
            return blockState.m_60767_() != Material.f_76305_;
        }
        return true;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Player player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        String structureName = config.basicStructureName.getName();
        BaseOption chosenOption = config.chosenOption;
        if (this.customBlockPos != null) {
            if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.FarmImproved.getName()) && chosenOption == FarmImprovedOptions.AutomatedChickenCoop) {
                for (int i = 0; i < 4; ++i) {
                    Chicken entity = new Chicken(EntityType.f_20555_, (Level)world);
                    entity.m_6034_((double)this.customBlockPos.m_123341_(), (double)this.customBlockPos.m_7494_().m_123342_(), (double)this.customBlockPos.m_123343_());
                    world.m_7967_((Entity)entity);
                }
            } else if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
                BuildingMethods.PlaceMineShaft(world, this.customBlockPos.m_7495_(), configuration.houseFacing, true);
            }
            this.customBlockPos = null;
        }
        if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.FarmAdvanced.getName()) && chosenOption == FarmAdvancedOptions.MonsterMasher) {
            int monstersPlaced = 0;
            for (BlockPos pos : this.mobSpawnerPos) {
                BlockEntity tileEntity = world.m_7702_(pos);
                if (!(tileEntity instanceof SpawnerBlockEntity)) continue;
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)tileEntity;
                switch (monstersPlaced) {
                    case 0: {
                        spawner.m_59801_().m_45462_(EntityType.f_20501_);
                        break;
                    }
                    case 1: {
                        spawner.m_59801_().m_45462_(EntityType.f_20524_);
                        break;
                    }
                    case 2: {
                        spawner.m_59801_().m_45462_(EntityType.f_20495_);
                        break;
                    }
                    default: {
                        spawner.m_59801_().m_45462_(EntityType.f_20558_);
                    }
                }
                ++monstersPlaced;
            }
        }
        if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName()) || structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBaseImproved.getName())) {
            BlockPos airPos = originalPos.m_6630_(4).m_5484_(configuration.houseFacing.m_122424_(), 1);
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7495_();
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7495_();
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7495_();
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_121945_(configuration.houseFacing.m_122424_()).m_7494_();
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7494_();
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_121945_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7494_();
            world.m_7471_(airPos, false);
        }
    }

    @Override
    protected boolean hasGlassColor(StructureConfiguration configuration) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        BaseOption chosenOption = config.chosenOption;
        return chosenOption.getHasGlassColor();
    }

    @Override
    protected FullDyeColor getGlassColor(StructureConfiguration configuration) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        return config.glassColor;
    }
}

