/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildShape;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class StructureGuiWorld
implements BlockAndTintGetter {
    private BuildClear clearShape;
    private ArrayList<BuildBlock> blocks;
    private HashMap<Long, BlockState> blocksByPosition;
    private BuildShape buildShape;
    private StructureConfiguration structureConfiguration;

    public StructureGuiWorld() {
        this.resetStructure();
    }

    public void resetStructure() {
        this.clearShape = null;
        this.blocks = null;
        this.blocksByPosition = new HashMap();
        this.buildShape = null;
        this.structureConfiguration = null;
    }

    public BuildClear getClearShape() {
        return this.clearShape;
    }

    public StructureGuiWorld setClearShape(BuildClear clearShape) {
        this.clearShape = clearShape;
        this.buildShape = clearShape.getShape();
        return this;
    }

    public ArrayList<BuildBlock> getBlocks() {
        return this.blocks;
    }

    public StructureGuiWorld setBlocks(ArrayList<BuildBlock> blocks) {
        this.blocks = blocks;
        return this;
    }

    public StructureGuiWorld setStructureConfiguration(StructureConfiguration configuration) {
        this.structureConfiguration = configuration;
        return this;
    }

    public boolean hasBlocksToRender() {
        return this.blocksByPosition != null && this.blocksByPosition.size() > 0;
    }

    public HashMap<Long, BlockState> getBlocksByPosition() {
        return this.blocksByPosition;
    }

    public void setupBlocks() {
        if (this.buildShape != null && this.blocks != null && this.blocks.size() > 0) {
            BlockPos startPosition = new BlockPos(0, 0, 0);
            this.blocksByPosition.clear();
            HashMap<Long, BlockState> blocksByPosition = new HashMap<Long, BlockState>();
            for (BuildBlock buildBlock : this.blocks) {
                Block foundBlock = (Block)Registry.f_122824_.m_7745_(buildBlock.getResourceLocation());
                if (foundBlock == null) continue;
                BlockPos pos = buildBlock.getStartingPosition().getRelativePosition(startPosition, this.buildShape.getDirection(), this.structureConfiguration.houseFacing);
                BlockState blockState = foundBlock.m_49966_();
                BuildBlock updatedBuildBlock = BuildBlock.SetBlockState(this.structureConfiguration, startPosition, buildBlock, foundBlock, blockState, this.buildShape.getDirection());
                blocksByPosition.put(pos.m_121878_(), updatedBuildBlock.getBlockState());
                BuildBlock subBlock = buildBlock.getSubBlock();
                if (subBlock == null) continue;
                BlockPos subPos = subBlock.getStartingPosition().getRelativePosition(startPosition, this.buildShape.getDirection(), this.structureConfiguration.houseFacing);
                BlockState subBlockState = foundBlock.m_49966_();
                BuildBlock updatedSubBuildBlock = BuildBlock.SetBlockState(this.structureConfiguration, startPosition, subBlock, foundBlock, subBlockState, this.buildShape.getDirection());
                blocksByPosition.put(subPos.m_121878_(), updatedSubBuildBlock.getBlockState());
            }
            this.blocksByPosition = blocksByPosition;
        }
    }

    public float m_7717_(Direction direction, boolean shaded) {
        return 1.0f;
    }

    public LevelLightEngine m_5518_() {
        return null;
    }

    public int m_6171_(BlockPos pos, ColorResolver color) {
        return color.m_130045_((Biome)ForgeRegistries.BIOMES.getValue(Biomes.f_48202_.m_211136_()), (double)pos.m_123341_(), (double)pos.m_123343_());
    }

    public int m_45517_(LightLayer type, BlockPos pos) {
        return 15;
    }

    public int m_45524_(BlockPos pos, int ambientDarkening) {
        return 15 - ambientDarkening;
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return null;
    }

    public BlockState m_8055_(BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (x < 0 || y < 0 || z < 0 || x >= this.buildShape.getWidth() || y >= this.buildShape.getHeight() || z >= this.buildShape.getLength()) {
            return Blocks.f_50016_.m_49966_();
        }
        return this.blocksByPosition.getOrDefault(pos.m_121878_(), Blocks.f_50016_.m_49966_());
    }

    public FluidState m_6425_(BlockPos pos) {
        return Fluids.f_76191_.m_76145_();
    }

    public int m_141928_() {
        return 255;
    }

    public int m_141937_() {
        return 0;
    }
}

