/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.gui.GuiNoOptions;
import com.wuest.prefab.structures.gui.StructureGuiWorld;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.render.StructureRenderHandler;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class GuiStructure
extends GuiBase {
    private static final RandomSource RAND = RandomSource.m_216327_();
    public BlockPos pos;
    public StructureTagMessage.EnumStructureConfiguration configurationEnum;
    protected Player player;
    protected Button btnCancel;
    protected Button btnBuild;
    protected Button btnVisualize;
    protected ResourceLocation structureImageLocation;
    protected StructureConfiguration configuration;
    protected Structure selectedStructure;
    protected StructureGuiWorld structureRenderer;
    protected int ticksWithScreenOpen;
    protected Direction houseFacing;
    private boolean isRendererSetup = false;
    private VertexBuffer buffer;

    public GuiStructure(String title) {
        super(title);
    }

    @Nullable
    public static BlockHitResult rayTrace(Vec3 from, Vec3 to, BlockGetter world) {
        ClipContext rayTraceContext = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult result = world.m_45547_(rayTraceContext);
        return result;
    }

    @Override
    public void m_7856_() {
        this.buffer = new VertexBuffer();
        this.player = this.getMinecraft().f_91074_;
        this.houseFacing = this.player.m_6350_().m_122424_();
        this.Initialize();
    }

    public void m_86600_() {
        ++this.ticksWithScreenOpen;
    }

    @Override
    protected void Initialize() {
        super.Initialize();
    }

    protected void InitializeStandardButtons() {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 113, grayBoxY + 167, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(grayBoxX + 215, grayBoxY + 167, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 10, grayBoxY + 167, 90, 20, "prefab.gui.button.cancel");
    }

    public void checkVisualizationSetting() {
        if (!CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            this.btnVisualize.f_93624_ = false;
        }
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(matrixStack, x, y);
        this.postButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        if (this.structureRenderer != null) {
            if (this.isRendererSetup) {
                this.renderStructureInScreen(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
            } else {
                this.rebuild();
                this.isRendererSetup = true;
            }
        }
        if (this.btnVisualize != null) {
            this.checkVisualizationSetting();
        }
    }

    @Override
    protected void preButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawStandardControlBoxAndImage(matrixStack, this.structureImageLocation, x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void postButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
    }

    protected void performCancelOrBuildOrHouseFacing(AbstractButton button) {
        if (button == this.btnCancel) {
            this.closeScreen();
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((Object)Utils.createStructureMessage(this.configuration.WriteToCompoundTag(), this.configurationEnum));
            this.closeScreen();
        }
    }

    protected void performPreview() {
        StructureRenderHandler.setStructure(this.selectedStructure, this.configuration);
        this.closeScreen();
    }

    protected void showNoOptionsScreen() {
        this.getMinecraft().m_91152_((Screen)new GuiNoOptions());
    }

    protected void updatedRenderedStructure() {
        if (this.structureRenderer != null && this.selectedStructure != null && this.configuration != null) {
            this.structureRenderer.resetStructure();
            this.structureRenderer.setClearShape(this.selectedStructure.getClearSpace()).setStructureConfiguration(this.configuration).setBlocks(this.selectedStructure.getBlocks()).setupBlocks();
            this.scheduleRebuild();
        }
    }

    private void rebuild() {
        PoseStack matrixStack = new PoseStack();
        this.buffer = new VertexBuffer();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        this.doWorldRenderPass(matrixStack, (VertexConsumer)bufferBuilder);
        BufferBuilder.RenderedBuffer renderedBuffer = bufferBuilder.m_231175_();
        this.buffer.m_231221_(renderedBuffer);
    }

    public void scheduleRebuild() {
        this.isRendererSetup = false;
    }

    protected void renderStructureInScreen(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int sizeX = this.structureRenderer.getClearShape().getShape().getWidth();
        int sizeY = this.structureRenderer.getClearShape().getShape().getHeight();
        int sizeZ = this.structureRenderer.getClearShape().getShape().getLength();
        float maxX = 180.0f;
        float maxY = 180.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = x + 186;
        int yPos = 40;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)xPos, (double)yPos, 100.0);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85837_((double)(-((float)sizeX)), (double)(-((float)sizeY)), (double)(-((float)sizeZ)));
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.m_27624_();
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-15.0f));
        rotMat.m_27646_(Vector3f.f_122223_.m_122240_(15.0f));
        float offX = (float)(-sizeX) / 2.0f + 1.0f;
        float offZ = (float)(-sizeZ) / 2.0f;
        float time = (float)this.ticksWithScreenOpen * 4.5f;
        matrixStack.m_85837_((double)(-offX), 0.0, (double)(-offZ));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-time));
        rotMat.m_27646_(Vector3f.f_122225_.m_122240_(time));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
        rotMat.m_27646_(Vector3f.f_122225_.m_122240_(-45.0f));
        matrixStack.m_85837_((double)offX, 0.0, (double)offZ);
        eye.m_123607_(rotMat);
        eye.m_123621_();
        this.render(matrixStack);
        matrixStack.m_85849_();
    }

    private void render(PoseStack matrixStack) {
        matrixStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.buffer.m_85921_();
        this.buffer.m_166867_(matrixStack.m_85850_().m_85861_(), RenderSystem.m_157192_(), GameRenderer.m_172823_());
        VertexBuffer.m_85931_();
        matrixStack.m_85849_();
    }

    private void renderElements(PoseStack matrixStack, Vector4f eye) {
        matrixStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85837_(0.0, 0.0, -1.0);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        buffers.m_109911_();
        matrixStack.m_85849_();
    }

    private void doWorldRenderPass(PoseStack matrixStack, VertexConsumer vertexConsumer) {
        for (Map.Entry<Long, BlockState> entry : this.structureRenderer.getBlocksByPosition().entrySet()) {
            BlockPos position = BlockPos.m_122022_((long)entry.getKey());
            BlockState blockState = entry.getValue();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
            Minecraft.m_91087_().m_91289_().m_234355_(blockState, position, (BlockAndTintGetter)this.structureRenderer, matrixStack, vertexConsumer, false, RAND);
            matrixStack.m_85849_();
        }
    }
}

