/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.items.StructureItem;
import com.wuest.prefab.structures.predefined.StructureHouseImproved;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class HouseImprovedConfiguration
extends StructureConfiguration {
    public static String tagKey = "houseConfig";
    private static String houseStyleTag = "houseStyle";
    private static String addChestTag = "addChests";
    private static String addChestContentsTag = "addChestContents";
    private static String addMineshaftTag = "addMineshaft";
    private static String bedColorTag = "bedColor";
    public HouseStyle houseStyle = HouseStyle.SPRUCE_HOME;
    public boolean addChests = true;
    public boolean addChestContents = true;
    public boolean addMineshaft = true;
    public DyeColor bedColor = DyeColor.RED;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.SPRUCE_HOME;
        this.bedColor = DyeColor.RED;
    }

    @Override
    protected CompoundTag CustomWriteToCompoundTag(CompoundTag tag) {
        tag.m_128405_(houseStyleTag, this.houseStyle.value);
        tag.m_128379_(addChestTag, this.addChests);
        tag.m_128379_(addChestContentsTag, this.addChestContents);
        tag.m_128379_(addMineshaftTag, this.addMineshaft);
        tag.m_128405_(bedColorTag, this.bedColor.m_41060_());
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundTag messageTag, StructureConfiguration config) {
        HouseImprovedConfiguration houseConfiguration = (HouseImprovedConfiguration)config;
        if (messageTag.m_128441_(houseStyleTag)) {
            houseConfiguration.houseStyle = HouseStyle.ValueOf(messageTag.m_128451_(houseStyleTag));
        }
        if (messageTag.m_128441_(addChestTag)) {
            houseConfiguration.addChests = messageTag.m_128471_(addChestTag);
        }
        if (messageTag.m_128441_(addChestContentsTag)) {
            houseConfiguration.addChestContents = messageTag.m_128471_(addChestContentsTag);
        }
        if (messageTag.m_128441_(addMineshaftTag)) {
            houseConfiguration.addMineshaft = messageTag.m_128471_(addMineshaftTag);
        }
        if (messageTag.m_128441_(bedColorTag)) {
            houseConfiguration.bedColor = DyeColor.m_41053_((int)messageTag.m_128451_(bedColorTag));
        }
    }

    @Override
    public HouseImprovedConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        HouseImprovedConfiguration config = new HouseImprovedConfiguration();
        return (HouseImprovedConfiguration)super.ReadFromCompoundTag(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureHouseImproved structure = (StructureHouseImproved)StructureHouseImproved.CreateInstance(this.houseStyle.getStructureLocation(), StructureHouseImproved.class);
        if (structure.BuildStructure(this, world, hitBlockPos, player)) {
            this.RemoveStructureItemFromPlayer(player, (StructureItem)((Object)ModRegistry.ModerateHouse.get()));
        }
    }

    public static enum HouseStyle {
        SPRUCE_HOME(0, "prefab.gui.house.improved.spruce", new ResourceLocation("prefab", "textures/gui/house_improved_spruce.png"), "assets/prefab/structures/house_improved_spruce.zip"),
        ACACIA_HOME(1, "prefab.gui.house.improved.acacia", new ResourceLocation("prefab", "textures/gui/house_improved_acacia.png"), "assets/prefab/structures/house_improved_acacia.zip"),
        EARTHEN_HOME(2, "prefab.gui.house.improved.earthen", new ResourceLocation("prefab", "textures/gui/house_improved_earthen.png"), "assets/prefab/structures/house_improved_earthen.zip"),
        JUNGLE_TREE_HOME(3, "prefab.gui.house.improved.jungle", new ResourceLocation("prefab", "textures/gui/house_improved_jungle.png"), "assets/prefab/structures/house_improved_jungle.zip"),
        NETHER_HOME(4, "prefab.gui.house.improved.nether", new ResourceLocation("prefab", "textures/gui/house_improved_nether.png"), "assets/prefab/structures/house_improved_nether.zip"),
        MOUNTAIN_HOME(5, "prefab.gui.house.improved.mountain", new ResourceLocation("prefab", "textures/gui/house_improved_mountain.png"), "assets/prefab/structures/house_improved_mountain.zip"),
        ACACIA_HOME2(6, "prefab.gui.house.improved.acacia_2", new ResourceLocation("prefab", "textures/gui/house_improved_acacia_2.png"), "assets/prefab/structures/house_improved_acacia_2.zip"),
        MODERN_HOME(7, "prefab.gui.modern.house", new ResourceLocation("prefab", "textures/gui/house_improved_modern.png"), "assets/prefab/structures/house_improved_modern.zip"),
        CRIMSON_HOME(8, "prefab.gui.house.improved.crimson_house", new ResourceLocation("prefab", "textures/gui/house_improved_crimson.png"), "assets/prefab/structures/house_improved_crimson.zip"),
        TOWER_HOME(9, "prefab.gui.house.improved.tower_house", new ResourceLocation("prefab", "textures/gui/house_improved_tower.png"), "assets/prefab/structures/house_improved_tower.zip"),
        HOBBIT_HOME(10, "prefab.gui.house.improved.hobbit_house", new ResourceLocation("prefab", "textures/gui/house_improved_hobbit.png"), "assets/prefab/structures/house_improved_hobbit.zip"),
        COTTAGE_HOME(11, "prefab.gui.house.improved.cottage_house", new ResourceLocation("prefab", "textures/gui/house_improved_cottage.png"), "assets/prefab/structures/house_improved_cottage.zip");

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.structureLocation = structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            for (HouseStyle currentValue : HouseStyle.values()) {
                if (currentValue.value != value) continue;
                return currentValue;
            }
            return SPRUCE_HOME;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public String getTranslationKey() {
            return this.displayName;
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

