/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Triple;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.UppercaseEnumAdapter;
import com.wuest.prefab.ZipUtil;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildEntity;
import com.wuest.prefab.structures.base.BuildProperty;
import com.wuest.prefab.structures.base.BuildTileEntity;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.PositionOffset;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.events.StructureEventHandler;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class Structure {
    public ArrayList<BlockPos> allBlockPositions = new ArrayList();
    public ArrayList<BlockPos> clearedBlockPos = new ArrayList();
    public ArrayList<BuildBlock> priorityOneBlocks = new ArrayList();
    public ArrayList<BuildBlock> airBlocks = new ArrayList();
    public StructureConfiguration configuration;
    public ServerLevel world;
    public BlockPos originalPos;
    public boolean hasAirBlocks = false;
    public boolean entitiesRemoved = false;
    @Expose
    public ArrayList<BuildTileEntity> tileEntities = new ArrayList();
    @Expose
    public ArrayList<BuildEntity> entities = new ArrayList();
    @Expose
    private String name;
    @Expose
    private BuildClear clearSpace;
    @Expose
    private ArrayList<BuildBlock> blocks;

    public Structure() {
        this.Initialize();
    }

    public static <T extends Structure> T CreateInstance(String resourceLocation, Class<? extends Structure> child) {
        GsonBuilder builder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation();
        builder.registerTypeAdapter(Direction.class, (Object)new UppercaseEnumAdapter());
        Gson file = builder.create();
        Structure structure = (Structure)file.fromJson(ZipUtil.decompressResource(resourceLocation), child);
        return (T)structure;
    }

    public static void CreateStructureFile(Structure structure, String fileLocation) {
        try {
            GsonBuilder builder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation();
            builder.registerTypeAdapter(Direction.class, (Object)new UppercaseEnumAdapter());
            Gson converter = builder.create();
            StringWriter stringWriter = new StringWriter();
            converter.toJson((Object)structure, (Appendable)stringWriter);
            ZipUtil.zipStringToFile(stringWriter.toString(), fileLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ScanStructure(Level world, BlockPos originalPos, BlockPos cornerPos1, BlockPos cornerPos2, String fileLocation, BuildClear clearedSpace, Direction playerFacing, boolean includeAir, boolean excludeWater) {
        Structure scannedStructure = new Structure();
        scannedStructure.setClearSpace(clearedSpace);
        for (BlockPos currentPos : BlockPos.m_121940_((BlockPos)cornerPos1, (BlockPos)cornerPos2)) {
            if (world.m_46859_(currentPos) && !includeAir) continue;
            BlockState currentState = world.m_8055_(currentPos);
            Block currentBlock = currentState.m_60734_();
            if (currentState.m_60767_() == Material.f_76305_ && excludeWater) continue;
            BuildBlock buildBlock = Structure.createBuildBlockFromBlockState(currentState, currentBlock, currentPos, originalPos);
            if (currentBlock instanceof DoorBlock) {
                DoubleBlockHalf blockHalf = (DoubleBlockHalf)currentState.m_61143_((Property)DoorBlock.f_52730_);
                if (blockHalf != DoubleBlockHalf.LOWER) continue;
                BlockState upperHalfState = world.m_8055_(currentPos.m_7494_());
                if (upperHalfState.m_60734_() instanceof DoorBlock) {
                    Block upperBlock = upperHalfState.m_60734_();
                    BuildBlock upperHalf = Structure.createBuildBlockFromBlockState(upperHalfState, upperBlock, currentPos.m_7494_(), originalPos);
                    buildBlock.setSubBlock(upperHalf);
                }
            } else if (currentBlock instanceof BedBlock) {
                BedPart bedPart = (BedPart)currentState.m_61143_((Property)BedBlock.f_49440_);
                if (bedPart != BedPart.HEAD) continue;
                BlockState bedFoot = null;
                boolean foundFoot = false;
                Direction facing = Direction.NORTH;
                while (!foundFoot) {
                    bedFoot = world.m_8055_(currentPos.m_121945_(facing));
                    if (bedFoot.m_60734_() instanceof BedBlock && bedFoot.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
                        foundFoot = true;
                        break;
                    }
                    if ((facing = facing.m_122427_()) != Direction.NORTH) continue;
                }
                if (foundFoot) {
                    Block footBedBlock = bedFoot.m_60734_();
                    BuildBlock bed = Structure.createBuildBlockFromBlockState(bedFoot, footBedBlock, currentPos.m_121945_(facing), originalPos);
                    buildBlock.setSubBlock(bed);
                }
            }
            scannedStructure.getBlocks().add(buildBlock);
            BlockEntity tileEntity = world.m_7702_(currentPos);
            if (tileEntity == null || tileEntity instanceof ChestBlockEntity && ((ChestBlockEntity)tileEntity).m_7983_() || tileEntity instanceof FurnaceBlockEntity && ((FurnaceBlockEntity)tileEntity).m_7983_()) continue;
            ResourceLocation resourceLocation = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)tileEntity.m_58903_());
            CompoundTag tagCompound = tileEntity.m_187480_();
            BuildTileEntity buildTileEntity = new BuildTileEntity();
            assert (resourceLocation != null);
            buildTileEntity.setEntityDomain(resourceLocation.m_135827_());
            buildTileEntity.setEntityName(resourceLocation.m_135815_());
            buildTileEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
            buildTileEntity.setEntityNBTData(tagCompound);
            scannedStructure.tileEntities.add(buildTileEntity);
        }
        int x_radiusRangeBegin = Math.min(cornerPos1.m_123341_(), cornerPos2.m_123341_());
        int x_radiusRangeEnd = Math.max(cornerPos1.m_123341_(), cornerPos2.m_123341_());
        int y_radiusRangeBegin = Math.min(cornerPos1.m_123342_(), cornerPos2.m_123342_());
        int y_radiusRangeEnd = Math.max(cornerPos1.m_123342_(), cornerPos2.m_123342_());
        int z_radiusRangeBegin = Math.min(cornerPos1.m_123343_(), cornerPos2.m_123343_());
        int z_radiusRangeEnd = Math.max(cornerPos1.m_123343_(), cornerPos2.m_123343_());
        AABB axis = new AABB(cornerPos1, cornerPos2);
        for (Entity entity : world.m_45933_(null, axis)) {
            BlockPos entityPos = entity.m_20183_();
            if (entity instanceof HangingEntity) {
                entityPos = ((HangingEntity)entity).m_31748_();
            }
            if (entityPos.m_123341_() < x_radiusRangeBegin || entityPos.m_123341_() > x_radiusRangeEnd || entityPos.m_123343_() < z_radiusRangeBegin || entityPos.m_123343_() > z_radiusRangeEnd || entityPos.m_123342_() < y_radiusRangeBegin || entityPos.m_123342_() > y_radiusRangeEnd) continue;
            BuildEntity buildEntity = new BuildEntity();
            buildEntity.setEntityResourceString(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
            buildEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(entityPos, originalPos));
            buildEntity.entityXAxisOffset = (double)entityPos.m_123341_() - entity.m_20185_();
            buildEntity.entityYAxisOffset = (double)entityPos.m_123342_() - entity.m_20186_();
            buildEntity.entityZAxisOffset = (double)entityPos.m_123343_() - entity.m_20189_();
            if (entity instanceof ItemFrame) {
                buildEntity.entityYAxisOffset *= -1.0;
            }
            if (entity instanceof HangingEntity) {
                buildEntity.entityFacing = entity.m_6350_();
            }
            CompoundTag entityTagCompound = new CompoundTag();
            entity.m_20086_(entityTagCompound);
            buildEntity.setEntityNBTData(entityTagCompound);
            scannedStructure.entities.add(buildEntity);
        }
        Structure.CreateStructureFile(scannedStructure, fileLocation);
    }

    public static BuildBlock createBuildBlockFromBlockState(BlockState currentState, Block currentBlock, BlockPos currentPos, BlockPos originalPos) {
        BuildBlock buildBlock = new BuildBlock();
        ResourceLocation blockIdentifier = Registry.f_122824_.m_7981_((Object)currentBlock);
        buildBlock.setBlockDomain(blockIdentifier.m_135827_());
        buildBlock.setBlockName(blockIdentifier.m_135815_());
        buildBlock.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
        buildBlock.blockPos = currentPos;
        Collection properties = currentState.m_61147_();
        for (Property entry : properties) {
            BuildProperty property = new BuildProperty();
            property.setName(entry.m_61708_());
            Comparable value = currentState.m_61143_(entry);
            try {
                if (currentBlock instanceof RotatedPillarBlock && property.getName().equals("axis")) {
                    Direction.Axis axis = (Direction.Axis)value;
                    property.setValue(axis.m_7912_());
                } else if (currentBlock instanceof CarpetBlock && property.getName().equals("color")) {
                    DyeColor dyeColor = (DyeColor)value;
                    property.setValue(dyeColor.m_7912_());
                } else if (value instanceof StringRepresentable) {
                    StringRepresentable stringSerializable = (StringRepresentable)value;
                    property.setValue(stringSerializable.m_7912_());
                } else {
                    property.setValue(value.toString());
                }
            }
            catch (Exception ex) {
                Prefab.LOGGER.error("Unable to set property [" + property.getName() + "] to value [" + value + "] for Block [" + buildBlock.getBlockDomain() + ":" + buildBlock.getBlockName() + "].");
                throw ex;
            }
            buildBlock.getProperties().add(property);
        }
        return buildBlock;
    }

    public static PositionOffset getStartingPositionFromOriginalAndCurrentPosition(BlockPos currentPos, BlockPos originalPos) {
        PositionOffset positionOffSet = new PositionOffset();
        if (currentPos.m_123341_() > originalPos.m_123341_()) {
            positionOffSet.setEastOffset(currentPos.m_123341_() - originalPos.m_123341_());
        } else {
            positionOffSet.setWestOffset(originalPos.m_123341_() - currentPos.m_123341_());
        }
        if (currentPos.m_123343_() > originalPos.m_123343_()) {
            positionOffSet.setSouthOffset(currentPos.m_123343_() - originalPos.m_123343_());
        } else {
            positionOffSet.setNorthOffset(originalPos.m_123343_() - currentPos.m_123343_());
        }
        positionOffSet.setHeightOffset(currentPos.m_123342_() - originalPos.m_123342_());
        return positionOffSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public BuildClear getClearSpace() {
        return this.clearSpace;
    }

    public void setClearSpace(BuildClear value) {
        this.clearSpace = value;
    }

    public ArrayList<BuildBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<BuildBlock> value) {
        this.blocks = value;
    }

    public void Initialize() {
        this.name = "";
        this.clearSpace = new BuildClear();
        this.blocks = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    public boolean BuildStructure(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Player player) {
        BlockPos endBlockPos;
        BlockPos startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, this.clearSpace.getShape().getDirection(), configuration.houseFacing);
        Triple<Boolean, BlockState, BlockPos> checkResult = BuildingMethods.CheckBuildSpaceForAllowedBlockReplacement(world, startBlockPos, endBlockPos = startBlockPos.m_5484_(configuration.houseFacing.m_122428_(), this.clearSpace.getShape().getWidth() - 1).m_5484_(configuration.houseFacing.m_122424_(), this.clearSpace.getShape().getLength() - 1).m_5484_(Direction.UP, this.clearSpace.getShape().getHeight()), player);
        if (!checkResult.getFirst().booleanValue()) {
            MutableComponent message = Component.m_237110_((String)"prefab.gui.structure.nobuild", (Object[])new Object[]{Registry.f_122824_.m_7981_((Object)checkResult.getSecond().m_60734_()).toString(), checkResult.getThird().m_123341_(), checkResult.getThird().m_123342_(), checkResult.getThird().m_123343_()});
            message.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
            player.m_213846_((Component)message);
            return false;
        }
        if (CommonProxy.proxyConfiguration.serverConfiguration.playBuildingSound) {
            world.m_5594_(null, originalPos, (SoundEvent)ModRegistry.BuildingBlueprint.get(), SoundSource.NEUTRAL, 0.8f, 0.8f);
        }
        if (!this.BeforeBuilding(configuration, (Level)world, originalPos, player)) {
            try {
                this.ClearSpace(configuration, (Level)world, startBlockPos, endBlockPos);
                boolean blockPlacedWithCobbleStoneInstead = false;
                ArrayList<Tuple<BlockState, BlockPos>> laterBlocks = new ArrayList<Tuple<BlockState, BlockPos>>();
                for (BuildBlock buildBlock : this.getBlocks()) {
                    Block foundBlock = (Block)ForgeRegistries.BLOCKS.getValue(buildBlock.getResourceLocation());
                    if (foundBlock != null) {
                        void var11_17;
                        BlockState blockState = foundBlock.m_49966_();
                        BuildBlock subBlock = null;
                        if (this.WaterReplacedWithCobbleStone(configuration, buildBlock, (Level)world, originalPos, foundBlock, blockState, player).booleanValue() || this.CustomBlockProcessingHandled(configuration, buildBlock, (Level)world, originalPos, foundBlock, blockState, player).booleanValue()) continue;
                        if (!this.processedGlassBlock(configuration, buildBlock, (Level)world, originalPos, foundBlock)) {
                            BuildBlock buildBlock2 = BuildBlock.SetBlockState(configuration, originalPos, buildBlock, foundBlock, blockState, this.getClearSpace().getShape().getDirection());
                        }
                        if (var11_17.getSubBlock() != null) {
                            foundBlock = (Block)ForgeRegistries.BLOCKS.getValue(var11_17.getSubBlock().getResourceLocation());
                            blockState = foundBlock.m_49966_();
                            subBlock = BuildBlock.SetBlockState(configuration, originalPos, var11_17.getSubBlock(), foundBlock, blockState, this.getClearSpace().getShape().getDirection());
                        }
                        BlockPos setBlockPos = var11_17.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                        Block blockToPlace = var11_17.getBlockState().m_60734_();
                        if (!blockToPlace.f_60443_ && !(blockToPlace instanceof LiquidBlock) || blockToPlace instanceof CarpetBlock) {
                            laterBlocks.add(new Tuple<BlockState, BlockPos>(var11_17.getBlockState(), setBlockPos));
                        } else {
                            world.m_7731_(setBlockPos, var11_17.getBlockState(), 3);
                        }
                        if (subBlock == null) continue;
                        BlockPos subBlockPos = subBlock.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                        world.m_7731_(subBlockPos, subBlock.getBlockState(), 3);
                        continue;
                    }
                    String blockTypeNotFound = buildBlock.getResourceLocation().toString();
                    BuildBlock buildBlock3 = BuildBlock.SetBlockState(configuration, originalPos, buildBlock, Blocks.f_50652_, Blocks.f_50652_.m_49966_(), this.getClearSpace().getShape().getDirection());
                    BlockPos setBlockPos = buildBlock3.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                    world.m_7731_(setBlockPos, buildBlock3.getBlockState(), 3);
                    if (blockPlacedWithCobbleStoneInstead) continue;
                    blockPlacedWithCobbleStoneInstead = true;
                    Prefab.LOGGER.warn("A Block was in the structure, but it is not registered. This block was replaced with vanilla cobblestone instead. Block type not found: [" + blockTypeNotFound + "]");
                }
                for (Tuple tuple : laterBlocks) {
                    world.m_7731_((BlockPos)tuple.getSecond(), (BlockState)tuple.getFirst(), 3);
                }
                this.configuration = configuration;
                this.world = world;
                this.originalPos = originalPos;
                this.setBlockEntities();
                this.AfterBuilding(this.configuration, this.world, this.originalPos, player);
            }
            catch (Exception ex) {
                Prefab.LOGGER.error((Object)ex);
            }
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
                Block block = world.m_8055_(pos).m_60734_();
                world.m_6289_(pos, block);
            }
            if (StructureEventHandler.structuresToBuild.containsKey(player)) {
                StructureEventHandler.structuresToBuild.get(player).add(this);
            } else {
                ArrayList<Structure> structures = new ArrayList<Structure>();
                structures.add(this);
                StructureEventHandler.structuresToBuild.put(player, structures);
            }
        }
        return true;
    }

    public void BeforeClearSpaceBlockReplaced(BlockPos pos) {
    }

    public void BeforeHangingEntityRemoved(HangingEntity hangingEntity) {
    }

    protected boolean BeforeBuilding(StructureConfiguration configuration, Level world, BlockPos originalPos, Player player) {
        return false;
    }

    public void AfterBuilding(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Player player) {
    }

    protected void ClearSpace(StructureConfiguration configuration, Level world, BlockPos startBlockPos, BlockPos endBlockPos) {
        if (this.clearSpace.getShape().getWidth() > 0 && this.clearSpace.getShape().getLength() > 0) {
            this.clearedBlockPos = new ArrayList();
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
                if (!this.BlockShouldBeClearedDuringConstruction(configuration, world, this.originalPos, pos).booleanValue()) continue;
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            }
        } else {
            this.clearedBlockPos = new ArrayList();
        }
    }

    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Block foundBlock, BlockState blockState, Player player) {
        return false;
    }

    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, Level world, BlockPos originalPos, BlockPos blockPos) {
        return true;
    }

    protected Boolean WaterReplacedWithCobbleStone(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Block foundBlock, BlockState blockState, Player player) {
        boolean isOverWorld;
        boolean bl = isOverWorld = Level.f_46428_.compareTo(world.m_46472_()) == 0;
        if (world.m_6042_().f_63857_() || !isOverWorld && Prefab.proxy.getServerConfiguration().allowWaterInNonOverworldDimensions) {
            boolean foundWaterLikeBlock;
            boolean bl2 = foundWaterLikeBlock = foundBlock instanceof LiquidBlock && blockState.m_60767_() == Material.f_76305_ || foundBlock instanceof SeagrassBlock;
            if (!foundWaterLikeBlock) {
                for (BuildProperty property : block.getProperties()) {
                    if (!property.getName().equalsIgnoreCase(BlockStateProperties.f_61362_.m_61708_()) || !property.getValue().equalsIgnoreCase(BlockStateProperties.f_61362_.m_6940_(Boolean.valueOf(true)))) continue;
                    foundWaterLikeBlock = true;
                    break;
                }
            }
            if (foundWaterLikeBlock) {
                ResourceLocation cobbleIdentifier = Registry.f_122824_.m_7981_((Object)Blocks.f_50652_);
                block.setBlockDomain(cobbleIdentifier.m_135827_());
                block.setBlockName(cobbleIdentifier.m_135815_());
                block.setBlockState(Blocks.f_50652_.m_49966_());
                BlockPos setBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                world.m_7731_(setBlockPos, block.getBlockState(), 3);
                return true;
            }
        }
        return false;
    }

    protected boolean processedGlassBlock(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Block foundBlock) {
        if (!this.hasGlassColor(configuration)) {
            return false;
        }
        ResourceLocation blockIdentifier = Registry.f_122824_.m_7981_((Object)foundBlock);
        ResourceLocation glassIdentifier = Registry.f_122824_.m_7981_((Object)Blocks.f_50147_);
        ResourceLocation glassPaneIdentifier = Registry.f_122824_.m_7981_((Object)Blocks.f_50303_);
        if (blockIdentifier.m_135827_().equals(glassIdentifier.m_135827_()) && blockIdentifier.m_135815_().endsWith("glass")) {
            BlockState blockState = BuildingMethods.getStainedGlassBlock(this.getGlassColor(configuration));
            block.setBlockState(blockState);
            return true;
        }
        if (blockIdentifier.m_135827_().equals(glassPaneIdentifier.m_135827_()) && blockIdentifier.m_135815_().endsWith("glass_pane")) {
            BlockState blockState = BuildingMethods.getStainedGlassPaneBlock(this.getGlassColor(configuration));
            BuildBlock.SetBlockState(configuration, originalPos, block, foundBlock, blockState, this.getClearSpace().getShape().getDirection());
            return true;
        }
        return false;
    }

    protected boolean hasGlassColor(StructureConfiguration configuration) {
        return false;
    }

    protected FullDyeColor getGlassColor(StructureConfiguration configuration) {
        return FullDyeColor.CLEAR;
    }

    protected void setBlockEntities() {
        for (BuildTileEntity buildTileEntity : this.tileEntities) {
            try {
                if (buildTileEntity.getEntityName().equals("bed")) continue;
                BlockPos tileEntityPos = buildTileEntity.getStartingPosition().getRelativePosition(this.originalPos, this.getClearSpace().getShape().getDirection(), this.configuration.houseFacing);
                BlockEntity tileEntity = this.world.m_7702_(tileEntityPos);
                BlockState tileBlock = this.world.m_8055_(tileEntityPos);
                if (tileEntity != null) {
                    this.world.m_46747_(tileEntityPos);
                }
                if ((tileEntity = BlockEntity.m_155241_((BlockPos)tileEntityPos, (BlockState)tileBlock, (CompoundTag)buildTileEntity.getEntityDataTag())) == null) continue;
                this.world.m_46747_(tileEntityPos);
                tileEntity = BlockEntity.m_155241_((BlockPos)tileEntityPos, (BlockState)tileBlock, (CompoundTag)buildTileEntity.getEntityDataTag());
                this.world.m_151523_(tileEntity);
                this.world.m_46745_(tileEntityPos).m_8092_(true);
                tileEntity.m_6596_();
                Packet packet = tileEntity.m_58483_();
                if (packet == null) continue;
                this.world.m_7654_().m_6846_().m_11268_(packet);
            }
            catch (Exception ex) {
                Prefab.LOGGER.error((Object)ex);
            }
        }
    }
}

