/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.controls;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class GuiTextBox
extends AbstractWidget
implements Widget,
GuiEventListener {
    private final Font font;
    public int backgroundColor = Color.WHITE.getRGB();
    public boolean drawsTextShadow;
    @Nullable
    public String suggestion;
    private String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (string, integer) -> FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_);

    public GuiTextBox(Font textRenderer, int x, int y, int width, int height, Component text) {
        this(textRenderer, x, y, width, height, null, text);
    }

    public GuiTextBox(Font textRenderer, int x, int y, int width, int height, @Nullable EditBox copyFrom, Component text) {
        super(x, y, width, height, text);
        this.font = textRenderer;
        if (copyFrom != null) {
            this.setValue(copyFrom.m_94155_());
        }
    }

    public void setResponder(Consumer<String> rssponder) {
        this.responder = rssponder;
    }

    public void setFormatter(BiFunction<String, Integer, FormattedCharSequence> textFormatter) {
        this.formatter = textFormatter;
    }

    public void tick() {
        ++this.frame;
    }

    protected MutableComponent m_5646_() {
        Component component = this.m_6035_();
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String text) {
        if (this.filter.test(text)) {
            this.value = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.moveCursorToEnd();
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(text);
        }
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> validator) {
        this.filter = validator;
    }

    public void insertText(String textToWrite) {
        String string2;
        String string;
        int l;
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k < (l = (string = SharedConstants.m_136190_((String)textToWrite)).length())) {
            string = string.substring(0, k);
            l = k;
        }
        if (this.filter.test(string2 = new StringBuilder(this.value).replace(i, j, string).toString())) {
            this.value = string2;
            this.setCursorPosition(i + l);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    private void onValueChange(String newText) {
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void deleteText(int i) {
        if (Screen.m_96637_()) {
            this.deleteWords(i);
        } else {
            this.deleteChars(i);
        }
    }

    public void deleteWords(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(num) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String string;
                int k;
                int i = this.getCursorPos(num);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(string = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = string;
                    this.moveCursorTo(j);
                }
            }
        }
    }

    public int getWordPosition(int numWords) {
        return this.getWordPosition(numWords, this.getCursorPosition());
    }

    private int getWordPosition(int n, int pos) {
        return this.getWordPosition(n, pos, true);
    }

    private int getWordPosition(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean bl = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.value.length();
                if ((i = this.value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int num) {
        this.moveCursorTo(this.getCursorPos(num));
    }

    private int getCursorPos(int i) {
        return Util.m_137479_((String)this.value, (int)this.cursorPos, (int)i);
    }

    public void moveCursorTo(int pos) {
        this.setCursorPosition(pos);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = Screen.m_96638_();
        if (Screen.m_96634_((int)keyCode)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.isEditable) {
                this.insertText(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.m_93696_() && this.isEditable();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)codePoint)) {
            if (this.isEditable) {
                this.insertText(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl2 = bl = mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
        if (this.canLoseFocus) {
            this.setFocus(bl);
        }
        if (this.m_93696_() && bl && button == 0) {
            int i = Mth.m_14107_((double)mouseX) - this.f_93620_;
            if (this.bordered) {
                i -= 4;
            }
            String string = this.font.m_92834_(this.value.substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.font.m_92834_(string, i).length() + this.displayPos);
            return true;
        }
        return false;
    }

    public void setFocus(boolean isFocused) {
        this.m_93692_(isFocused);
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            int var10004;
            int var10003;
            int var10002;
            int j;
            if (this.isBordered()) {
                j = this.m_93696_() ? -1 : -6250336;
                GuiTextBox.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + this.f_93619_ + 1), (int)j);
                GuiTextBox.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)this.backgroundColor);
            }
            j = this.isEditable ? this.textColor : this.textColorUneditable;
            int k = this.cursorPos - this.displayPos;
            int l = this.highlightPos - this.displayPos;
            String string = this.font.m_92834_(this.value.substring(this.displayPos), this.getInnerWidth());
            boolean bl = k >= 0 && k <= string.length();
            boolean bl2 = this.m_93696_() && this.frame / 6 % 2 == 0 && bl;
            int m = this.bordered ? this.f_93620_ + 4 : this.f_93620_;
            int n = this.bordered ? this.f_93621_ + (this.f_93619_ - 8) / 2 : this.f_93621_;
            int o = m;
            if (l > string.length()) {
                l = string.length();
            }
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, k) : string;
                o = !this.drawsTextShadow ? this.font.m_92877_(poseStack, this.formatter.apply(string2, this.displayPos), (float)m, (float)n, j) : this.font.m_92744_(poseStack, this.formatter.apply(string2, this.displayPos), (float)m, (float)n, j);
            }
            boolean bl3 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
            int p = o;
            if (!bl) {
                p = k > 0 ? m + this.f_93618_ : m;
            } else if (bl3) {
                p = o - 1;
                --o;
            }
            if (!string.isEmpty() && bl && k < string.length()) {
                if (!this.drawsTextShadow) {
                    this.font.m_92877_(poseStack, this.formatter.apply(string.substring(k), this.cursorPos), (float)o, (float)n, j);
                } else {
                    this.font.m_92744_(poseStack, this.formatter.apply(string.substring(k), this.cursorPos), (float)o, (float)n, j);
                }
            }
            if (!bl3 && this.suggestion != null) {
                if (!this.drawsTextShadow) {
                    this.font.m_92883_(poseStack, this.suggestion, (float)(p - 1), (float)n, -8355712);
                } else {
                    this.font.m_92750_(poseStack, this.suggestion, (float)(p - 1), (float)n, -8355712);
                }
            }
            if (bl2) {
                if (bl3) {
                    var10002 = n - 1;
                    var10003 = p + 1;
                    var10004 = n + 1;
                    Objects.requireNonNull(this.font);
                    GuiComponent.m_93172_((PoseStack)poseStack, (int)p, (int)var10002, (int)var10003, (int)(var10004 + 9), (int)-3092272);
                } else if (!this.drawsTextShadow) {
                    this.font.m_92883_(poseStack, "_", (float)p, (float)n, j);
                } else {
                    this.font.m_92750_(poseStack, "_", (float)p, (float)n, j);
                }
            }
            if (l != k) {
                int q = m + this.font.m_92895_(string.substring(0, l));
                var10002 = n - 1;
                var10003 = q - 1;
                var10004 = n + 1;
                Objects.requireNonNull(this.font);
                this.renderHighlight(p, var10002, var10003, var10004 + 9);
            }
        }
    }

    private void renderHighlight(int startX, int startY, int endX, int endY) {
        int j;
        if (startX < endX) {
            j = startX;
            startX = endX;
            endX = j;
        }
        if (startY < endY) {
            j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.f_93620_ + this.f_93618_) {
            endX = this.f_93620_ + this.f_93618_;
        }
        if (startX > this.f_93620_ + this.f_93618_) {
            startX = this.f_93620_ + this.f_93618_;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_((double)startX, (double)endY, 0.0).m_5752_();
        bufferBuilder.m_5483_((double)endX, (double)endY, 0.0).m_5752_();
        bufferBuilder.m_5483_((double)endX, (double)startY, 0.0).m_5752_();
        bufferBuilder.m_5483_((double)startX, (double)startY, 0.0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.value = this.value.substring(0, length);
            this.onValueChange(this.value);
        }
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public void setCursorPosition(int pos) {
        this.cursorPos = Mth.m_14045_((int)pos, (int)0, (int)this.value.length());
    }

    private boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean enableBackgroundDrawing) {
        this.bordered = enableBackgroundDrawing;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setTextColorUneditable(int color) {
        this.textColorUneditable = color;
    }

    public boolean m_5755_(boolean focus) {
        return this.f_93624_ && this.isEditable ? super.m_5755_(focus) : false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
    }

    protected void m_7207_(boolean focused) {
        if (focused) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean enabled) {
        this.isEditable = enabled;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.f_93618_ - 8 : this.f_93618_;
    }

    public void setHighlightPos(int position) {
        int i = this.value.length();
        this.highlightPos = Mth.m_14045_((int)position, (int)0, (int)i);
        if (this.font != null) {
            if (this.displayPos > i) {
                this.displayPos = i;
            }
            int j = this.getInnerWidth();
            String string = this.font.m_92834_(this.value.substring(this.displayPos), j);
            int k = string.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.font.m_92837_(this.value, j, true).length();
            }
            if (this.highlightPos > k) {
                this.displayPos += this.highlightPos - k;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = Mth.m_14045_((int)this.displayPos, (int)0, (int)i);
        }
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean isVisible() {
        return this.f_93624_;
    }

    public void setVisible(boolean isVisible) {
        this.f_93624_ = isVisible;
    }

    public void setSuggestion(@Nullable String string) {
        this.suggestion = string;
    }

    public int getScreenX(int i) {
        return i > this.value.length() ? this.f_93620_ : this.f_93620_ + this.font.m_92895_(this.value.substring(0, i));
    }

    public void setX(int x) {
        this.f_93620_ = x;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.edit_box", (Object[])new Object[]{this.getValue()}));
    }
}

