/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.crafting;

import com.google.gson.JsonObject;
import com.wuest.prefab.Prefab;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class SmeltingCondition
implements ICondition {
    public static final ResourceLocation NAME = new ResourceLocation("prefab", "smelting_recipe");
    public String recipeKeyName;

    public SmeltingCondition(String identifier) {
        this.recipeKeyName = identifier;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return this.determineActiveRecipe();
    }

    public boolean determineActiveRecipe() {
        boolean result = false;
        if (this.recipeKeyName != null && Prefab.proxy.getServerConfiguration().recipeConfiguration.containsKey(this.recipeKeyName)) {
            result = Prefab.proxy.getServerConfiguration().recipeConfiguration.get(this.recipeKeyName);
        }
        return result;
    }

    public static class Serializer
    implements IConditionSerializer<SmeltingCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, SmeltingCondition value) {
            json.addProperty("recipeKey", value.recipeKeyName);
        }

        public SmeltingCondition read(JsonObject json) {
            String recipeKeyName = "recipeKey";
            return new SmeltingCondition(json.get(recipeKeyName).getAsString());
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

