/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.crafting;

import com.google.gson.JsonObject;
import com.wuest.prefab.Prefab;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class RecipeCondition
implements ICondition {
    public static final ResourceLocation NAME = new ResourceLocation("prefab", "config_recipe");
    public String recipeKey;

    public RecipeCondition(String recipeKey) {
        this.recipeKey = recipeKey;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return this.determineActiveRecipe();
    }

    private boolean determineActiveRecipe() {
        boolean result = false;
        if (this.recipeKey != null && Prefab.proxy.getServerConfiguration().recipeConfiguration.containsKey(this.recipeKey)) {
            result = Prefab.proxy.getServerConfiguration().recipeConfiguration.get(this.recipeKey);
        }
        return result;
    }

    public static class Serializer
    implements IConditionSerializer<RecipeCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, RecipeCondition value) {
            json.addProperty("recipeKey", value.recipeKey);
        }

        public RecipeCondition read(JsonObject json) {
            String recipeKeyName = "recipeKey";
            return new RecipeCondition(json.get(recipeKeyName).getAsString());
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

