/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.blocks;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.events.ModEventHandler;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPhasing
extends Block {
    private static final EnumProperty<EnumPhasingProgress> Phasing_Progress = EnumProperty.m_61587_((String)"phasing_progress", EnumPhasingProgress.class);
    private static final BooleanProperty Phasing_Out = BooleanProperty.m_61465_((String)"phasing_out");
    private int tickRate = 2;

    public BlockPhasing() {
        super(BlockBehaviour.Properties.m_60939_((Material)Prefab.SeeThroughImmovable).m_60918_(SoundType.f_56742_).m_60978_(0.6f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)Phasing_Out, (Comparable)Boolean.valueOf(false))).m_61124_(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.base)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{Phasing_Out, Phasing_Progress});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        EnumPhasingProgress progress;
        if (!world.m_5776_() && (progress = (EnumPhasingProgress)((Object)state.m_61143_(Phasing_Progress))) == EnumPhasingProgress.base) {
            world.m_186460_(pos, (Block)this, this.tickRate);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean poweredSide = context.m_43725_().m_46753_(context.m_8083_());
        if (poweredSide) {
            this.updateNeighborPhasicBlocks(true, context.m_43725_(), context.m_8083_(), this.m_49966_(), false, false);
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)Phasing_Out, (Comparable)Boolean.valueOf(poweredSide))).m_61124_(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.base));
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        EnumPhasingProgress currentState = (EnumPhasingProgress)((Object)state.m_61143_(Phasing_Progress));
        super.m_5707_(world, pos, state, player);
        ModEventHandler.RedstoneAffectedBlockPositions.remove(pos);
        boolean poweredSide = world.m_46753_(pos);
        if (poweredSide && currentState == EnumPhasingProgress.transparent) {
            this.updateNeighborPhasicBlocks(false, world, pos, state, false, false);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_, boolean p_220069_6_) {
        if (!worldIn.m_5776_() && blockIn.m_49966_().m_60803_()) {
            boolean poweredSide = worldIn.m_46753_(pos);
            EnumPhasingProgress currentState = (EnumPhasingProgress)((Object)state.m_61143_(Phasing_Progress));
            boolean setToTransparent = false;
            if (poweredSide && currentState == EnumPhasingProgress.base) {
                setToTransparent = true;
            }
            if (currentState == EnumPhasingProgress.base || currentState == EnumPhasingProgress.transparent) {
                this.updateNeighborPhasicBlocks(setToTransparent, worldIn, pos, state, true, true);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int updatedMeta;
        int tickDelay = this.tickRate;
        if (ModEventHandler.RedstoneAffectedBlockPositions.contains(pos)) {
            return;
        }
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.m_61143_(Phasing_Progress));
        boolean phasingOut = (Boolean)state.m_61143_((Property)Phasing_Out);
        if (progress == EnumPhasingProgress.base) {
            for (Direction facing : Direction.values()) {
                Block currentBlock = worldIn.m_8055_(pos.m_121945_(facing)).m_60734_();
                if (!(currentBlock instanceof BlockPhasing) || ModEventHandler.RedstoneAffectedBlockPositions.contains(pos.m_121945_(facing))) continue;
                worldIn.m_186460_(pos.m_121945_(facing), currentBlock, tickDelay);
            }
            phasingOut = true;
        }
        if ((updatedMeta = progress.getMeta()) == EnumPhasingProgress.eighty_percent.getMeta() && phasingOut) {
            tickDelay = 100;
        }
        if (updatedMeta == EnumPhasingProgress.transparent.getMeta() && phasingOut) {
            phasingOut = false;
        }
        if (updatedMeta == EnumPhasingProgress.twenty_percent.getMeta() && !phasingOut) {
            tickDelay = -1;
        }
        updatedMeta = phasingOut ? updatedMeta + 2 : updatedMeta - 2;
        progress = EnumPhasingProgress.ValueOf(updatedMeta);
        state = (BlockState)((BlockState)state.m_61124_((Property)Phasing_Out, (Comparable)Boolean.valueOf(phasingOut))).m_61124_(Phasing_Progress, (Comparable)((Object)progress));
        worldIn.m_7731_(pos, state, 3);
        if (tickDelay > 0) {
            worldIn.m_186460_(pos, (Block)this, tickDelay);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.m_61143_(Phasing_Progress));
        return progress != EnumPhasingProgress.transparent ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.m_61143_(Phasing_Progress));
        return progress != EnumPhasingProgress.transparent ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    @Nullable
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.m_61143_(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, worldIn, pos, context);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.m_61143_(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return Shapes.m_83040_();
        }
        VoxelShape aabb = super.m_6079_(state, worldIn, pos);
        return aabb;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.m_61143_(Phasing_Progress));
        return progress == EnumPhasingProgress.transparent;
    }

    protected void updateNeighborPhasicBlocks(boolean setToTransparent, Level worldIn, BlockPos pos, BlockState phasicBlockState, boolean setCurrentBlock, boolean triggeredByRedstone) {
        ArrayList<BlockPos> blocksToUpdate = new ArrayList<BlockPos>();
        BlockState updatedBlockState = (BlockState)((BlockState)phasicBlockState.m_61124_((Property)Phasing_Out, (Comparable)Boolean.valueOf(setToTransparent))).m_61124_(Phasing_Progress, (Comparable)((Object)(setToTransparent ? EnumPhasingProgress.transparent : EnumPhasingProgress.base)));
        this.findNeighborPhasicBlocks(worldIn, pos, updatedBlockState, 0, blocksToUpdate, setCurrentBlock);
        for (BlockPos positionToUpdate : blocksToUpdate) {
            worldIn.m_7731_(positionToUpdate, updatedBlockState, 3);
            if (!triggeredByRedstone) continue;
            if (ModEventHandler.RedstoneAffectedBlockPositions.contains(positionToUpdate) && !setToTransparent) {
                ModEventHandler.RedstoneAffectedBlockPositions.remove(positionToUpdate);
                continue;
            }
            if (ModEventHandler.RedstoneAffectedBlockPositions.contains(positionToUpdate) || !setToTransparent) continue;
            ModEventHandler.RedstoneAffectedBlockPositions.add(positionToUpdate);
        }
    }

    private int findNeighborPhasicBlocks(Level worldIn, BlockPos pos, BlockState desiredBlockState, int cascadeCount, ArrayList<BlockPos> cascadedBlockPos, boolean setCurrentBlock) {
        if (++cascadeCount > 100) {
            return cascadeCount;
        }
        if (setCurrentBlock) {
            cascadedBlockPos.add(pos);
        }
        for (Direction facing : Direction.values()) {
            Block neighborBlock = worldIn.m_8055_(pos.m_121945_(facing)).m_60734_();
            if (!(neighborBlock instanceof BlockPhasing)) continue;
            BlockState blockState = worldIn.m_8055_(pos.m_121945_(facing));
            EnumPhasingProgress progress = (EnumPhasingProgress)((Object)blockState.m_61143_(Phasing_Progress));
            if (cascadedBlockPos.contains(pos.m_121945_(facing)) || progress == desiredBlockState.m_61143_(Phasing_Progress)) continue;
            setCurrentBlock = true;
            cascadeCount = this.findNeighborPhasicBlocks(worldIn, pos.m_121945_(facing), desiredBlockState, cascadeCount, cascadedBlockPos, setCurrentBlock);
            if (cascadeCount > 100) break;
        }
        return cascadeCount;
    }

    public static enum EnumPhasingProgress implements StringRepresentable
    {
        base(0, "base"),
        twenty_percent(2, "twenty_percent"),
        forty_percent(4, "forty_percent"),
        sixty_percent(6, "sixty_percent"),
        eighty_percent(8, "eighty_percent"),
        transparent(10, "transparent");

        private int meta;
        private String name;

        private EnumPhasingProgress(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumPhasingProgress ValueOf(int meta) {
            for (EnumPhasingProgress progress : EnumPhasingProgress.values()) {
                if (progress.meta != meta) continue;
                return progress;
            }
            return base;
        }

        public int getMeta() {
            return this.meta;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

