/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.blocks;

import com.wuest.prefab.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockGlassSlab
extends GlassBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public BlockGlassSlab(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SlabBlock.f_56353_, WATERLOGGED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        Block adjacentBlock = adjacentBlockState.m_60734_();
        boolean foundBlock = Utils.doesBlockStateHaveTag(adjacentBlockState, new ResourceLocation("forge", "glass"));
        return foundBlock || adjacentBlock == this && (adjacentBlockState.m_61143_((Property)SlabBlock.f_56353_) == state.m_61143_((Property)SlabBlock.f_56353_) || adjacentBlockState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE && state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        SlabType slabtype = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
        switch (slabtype) {
            case DOUBLE: {
                return Shapes.m_83144_();
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60734_() == this) {
            boolean wasWaterlogged = (Boolean)blockstate.m_61143_((Property)WATERLOGGED);
            return (BlockState)((BlockState)blockstate.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(wasWaterlogged));
        }
        FluidState ifluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
        Direction direction = context.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? blockstate1 : (BlockState)blockstate1.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        SlabType slabtype = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
        if (slabtype != SlabType.DOUBLE && itemstack.m_41720_() == this.m_5456_()) {
            if (useContext.m_7058_()) {
                boolean flag = useContext.m_43720_().f_82480_ - (double)useContext.m_8083_().m_123342_() > 0.5;
                Direction direction = useContext.m_43719_();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.m_122434_().m_122479_();
                }
                return direction == Direction.DOWN || !flag && direction.m_122434_().m_122479_();
            }
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE && this.slabReceiveFluid(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE && this.slabCanContainFluid(worldIn, pos, state, fluidIn);
    }

    private boolean slabCanContainFluid(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluidIn == Fluids.f_76193_;
    }

    private boolean slabReceiveFluid(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_) {
            if (!worldIn.m_5776_()) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE), 3);
                worldIn.m_186469_(pos, fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE), 3);
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        return ItemStack.f_41583_;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        if (type == PathComputationType.WATER) {
            return worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        }
        return false;
    }
}

