/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.client.gui.CookingPotScreen;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMenu;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModMenuTypes;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.integration.jei.FDRecipeTypes;
import vectorwing.farmersdelight.integration.jei.FDRecipes;
import vectorwing.farmersdelight.integration.jei.category.CookingRecipeCategory;
import vectorwing.farmersdelight.integration.jei.category.CuttingRecipeCategory;
import vectorwing.farmersdelight.integration.jei.category.DecompositionRecipeCategory;
import vectorwing.farmersdelight.integration.jei.resource.DecompositionDummy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("farmersdelight", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CookingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CuttingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new DecompositionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        FDRecipes modRecipes = new FDRecipes();
        registration.addRecipes(FDRecipeTypes.COOKING, modRecipes.getCookingPotRecipes());
        registration.addRecipes(FDRecipeTypes.CUTTING, modRecipes.getCuttingBoardRecipes());
        registration.addRecipes(FDRecipeTypes.DECOMPOSITION, (List)ImmutableList.of((Object)new DecompositionDummy()));
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.STRAW.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.straw", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.HAM.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.ham", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.SMOKED_HAM.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.ham", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.FLINT_KNIFE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.IRON_KNIFE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.DIAMOND_KNIFE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.NETHERITE_KNIFE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.GOLDEN_KNIFE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.WILD_CABBAGES.get()), new ItemStack((ItemLike)ModItems.CABBAGE.get()), new ItemStack((ItemLike)ModItems.CABBAGE_LEAF.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.wild_cabbages", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.WILD_BEETROOTS.get()), new ItemStack((ItemLike)Items.f_42732_)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.wild_beetroots", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.WILD_CARROTS.get()), new ItemStack((ItemLike)Items.f_42619_)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.wild_carrots", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.WILD_ONIONS.get()), new ItemStack((ItemLike)ModItems.ONION.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.wild_onions", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.WILD_POTATOES.get()), new ItemStack((ItemLike)Items.f_42620_)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.wild_potatoes", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.WILD_TOMATOES.get()), new ItemStack((ItemLike)ModItems.TOMATO.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.wild_tomatoes", new Object[0])});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.WILD_RICE.get()), new ItemStack((ItemLike)ModItems.RICE.get()), new ItemStack((ItemLike)ModItems.RICE_PANICLE.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation("jei.info.wild_rice", new Object[0])});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.COOKING_POT.get()), new RecipeType[]{FDRecipeTypes.COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.CUTTING_BOARD.get()), new RecipeType[]{FDRecipeTypes.CUTTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.STOVE.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.SKILLET.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ORGANIC_COMPOST.get()), new RecipeType[]{FDRecipeTypes.DECOMPOSITION});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CookingPotScreen.class, 89, 25, 24, 17, new RecipeType[]{FDRecipeTypes.COOKING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CookingPotMenu.class, (MenuType)ModMenuTypes.COOKING_POT.get(), FDRecipeTypes.COOKING, 0, 6, 9, 36);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

